/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.messaging;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.slf4j.LoggerFactory;

public class Messenger {
    private final MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.builder().resolver(StandardTags.color()).resolver(StandardTags.decorations()).resolver(StandardTags.reset()).build()).build();
    private String prefix;

    public void setDefaultPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public void send(CommandSource recipient, String message) {
        if (recipient != null && message != null) {
            if (recipient instanceof Player && !((Player)recipient).isActive()) {
                return;
            }
            message = message.replace("\u00a7", "&").replace("&", "&amp;");
            Component component = this.miniMessage.deserialize((Object)(this.prefix + message));
            recipient.sendMessage(component);
        }
    }

    public void send(CommandSource recipient, List<String> messages) {
        if (recipient != null && messages != null) {
            if (recipient instanceof Player && !((Player)recipient).isActive()) {
                return;
            }
            messages.forEach(msg -> {
                msg = msg.replace("\u00a7", "&").replace("&", "&amp;");
                Component component = this.miniMessage.deserialize((Object)(this.prefix + msg));
                recipient.sendMessage(component);
            });
        }
    }

    public void sendCustomPrefix(CommandSource recipient, String customPrefix, String message) {
        if (recipient != null && message != null) {
            if (recipient instanceof Player && !((Player)recipient).isActive()) {
                return;
            }
            message = message.replace("\u00a7", "&").replace("&", "&amp;");
            Component component = this.miniMessage.deserialize((Object)(customPrefix + message));
            recipient.sendMessage(component);
        }
    }

    public void sendConsole(String message) {
        if (message != null) {
            LoggerFactory.getILoggerFactory().getLogger("PrivateMessages").info(this.prefix + message);
        }
    }
}

