/*
 * Decompiled with CFR 0.152.
 */
package pl.mirotcz.privatemessages.velocity.utils;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.mirotcz.privatemessages.Message;
import pl.mirotcz.privatemessages.velocity.PrivateMessages;
import pl.mirotcz.privatemessages.velocity.data.DateRelationType;
import pl.mirotcz.privatemessages.velocity.data.MessagesRetrievalError;
import pl.mirotcz.privatemessages.velocity.data.MessagesRetrievalResult;

public class MainUtils {
    private PrivateMessages instance;

    public MainUtils(PrivateMessages plugin) {
        this.instance = plugin;
    }

    public void reloadPlugin() {
        this.instance.getManagers().getConfigManagers().reloadConfigs();
        this.instance.getMessages().load(this.instance.getManagers().getConfigManagers().getLangConfigManager());
        this.instance.getSettings().load(this.instance.getManagers().getConfigManagers().getMainConfigManager());
    }

    public List<String> getApplicablePlayerCompletions(CommandSource sender, String playerArg) {
        ArrayList<String> completions = new ArrayList<String>();
        boolean first_arg_not_empty = playerArg != null && !playerArg.isEmpty();
        boolean vanish_support = this.instance.getManagers().getIntegrationsManager().isVanishSupported();
        boolean sender_vanish_bypass = sender.hasPermission("pm.vanishbypass");
        for (Player player : this.instance.getServer().getAllPlayers()) {
            if (vanish_support && this.instance.getVanish().isVanished(player) && !sender_vanish_bypass) continue;
            if (first_arg_not_empty) {
                if (!player.getUsername().toLowerCase().startsWith(playerArg.toLowerCase())) continue;
                completions.add(player.getUsername());
                continue;
            }
            completions.add(player.getUsername());
        }
        return completions;
    }

    public boolean isIgnoredOnSupportedIntegrations(String ignoredName, String ignoringName) {
        Map<String, List<String>> essentials_ignores = this.instance.getManagers().getIntegrationsManager().getEssentialsIgnores();
        if (!essentials_ignores.containsKey(ignoringName)) {
            return false;
        }
        return essentials_ignores.get(ignoringName).contains(ignoredName);
    }

    public LocalDateTime getLocalDateTimeFromCommandString(String dateTimeStr) {
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter formatter : this.instance.getSettings().IN_COMMAND_DATETIME_FORMATTERS) {
            try {
                localDateTime = LocalDateTime.parse(dateTimeStr, formatter);
                return localDateTime;
            }
            catch (DateTimeParseException e) {
            }
        }
        return localDateTime;
    }

    public MessagesRetrievalResult getMessagesMatchingExpression(String expression) {
        long timestamp = 0L;
        List<Message> messages = new ArrayList<Message>();
        String[] parts = expression.split(" ");
        boolean allMessagesOnServer = false;
        if (parts.length == 0) {
            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
        }
        if (parts.length == 1) {
            if (parts[0].equalsIgnoreCase("ALL")) {
                messages = this.instance.getStorage().getMessagesFromHistory();
                allMessagesOnServer = true;
            } else {
                String[] ids = parts[0].split(",");
                ArrayList<Long> idsList = new ArrayList<Long>();
                for (String id : ids) {
                    try {
                        Long msgId = Long.parseLong(id);
                        idsList.add(msgId);
                    }
                    catch (NumberFormatException ex) {
                        return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_MESSAGE_ID);
                    }
                }
                messages = this.instance.getStorage().getMessagesFromHistory(idsList);
            }
        } else if (parts.length == 2) {
            namesPair = parts[0].split(",");
            if (namesPair.length > 2) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
            }
            boolean isNamesPair = namesPair.length == 2;
            String player1 = namesPair[0];
            String player2 = null;
            if (isNamesPair) {
                player2 = namesPair[1];
            }
            if (parts[1].equalsIgnoreCase("ALL")) {
                messages = !isNamesPair ? this.instance.getStorage().getMessagesFromHistory(player1) : this.instance.getStorage().getMessagesFromHistory(player1, player2);
            } else {
                boolean isValidDateTimePresent = true;
                String dateTimeStr = parts[1];
                Instant instant = null;
                LocalDateTime localDateTime = this.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                instant = localDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                switch (parts[0].toUpperCase()) {
                    case "BEFORE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.BEFORE);
                        break;
                    }
                    case "AFTER": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.AFTER);
                        break;
                    }
                    case "TO": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.TO);
                        break;
                    }
                    case "SINCE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.SINCE);
                    }
                }
            }
        } else if (parts.length == 3) {
            if (parts[0].equalsIgnoreCase("RANGE")) {
                startDateTimeStr = parts[1];
                String endDateTimeStr = parts[2];
                Instant endInstant = null;
                LocalDateTime startLocalDateTime = this.getLocalDateTimeFromCommandString(startDateTimeStr);
                LocalDateTime endLocalDateTime = this.getLocalDateTimeFromCommandString(endDateTimeStr);
                if (startLocalDateTime == null || endLocalDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant startInstant = startLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                endInstant = endLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                long startTimestamp = startInstant.toEpochMilli();
                long endTimestamp = endInstant.toEpochMilli();
                messages = this.instance.getStorage().getMessagesFromHistoryInDatesRange(startTimestamp, endTimestamp);
            } else {
                namesPair = parts[0].split(",");
                String dateTimeStr = parts[2];
                LocalDateTime localDateTime = this.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant instant = localDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                if (namesPair.length < 2) {
                    String playerName = parts[0];
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = this.instance.getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = this.instance.getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = this.instance.getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = this.instance.getStorage().getPlayerMessagesFromHistoryRelativeToDate(playerName, timestamp, DateRelationType.SINCE);
                        }
                    }
                } else {
                    String player1 = namesPair[0];
                    String player2 = namesPair[1];
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = this.instance.getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = this.instance.getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = this.instance.getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = this.instance.getStorage().getPlayersPairMessagesFromHistoryRelativeToDate(player1, player2, timestamp, DateRelationType.SINCE);
                        }
                    }
                }
            }
        } else if (parts.length == 4 && parts[1].equalsIgnoreCase("RANGE")) {
            startDateTimeStr = parts[2];
            String endDateTimeStr = parts[3];
            Instant endInstant = null;
            LocalDateTime startLocalDateTime = this.getLocalDateTimeFromCommandString(startDateTimeStr);
            LocalDateTime endLocalDateTime = this.getLocalDateTimeFromCommandString(endDateTimeStr);
            if (startLocalDateTime == null || endLocalDateTime == null) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
            }
            Instant startInstant = startLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
            endInstant = endLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
            long startTimestamp = startInstant.toEpochMilli();
            long endTimestamp = endInstant.toEpochMilli();
            String[] namesPair = parts[0].split(",");
            if (namesPair.length < 2) {
                String playerName = parts[0];
                messages = this.instance.getStorage().getPlayerMessagesFromHistoryInDatesRange(playerName, startTimestamp, endTimestamp);
            } else {
                String player1 = namesPair[0];
                String player2 = namesPair[1];
                messages = this.instance.getStorage().getPlayersPairMessagesFromHistoryInDatesRange(player1, player2, startTimestamp, endTimestamp);
            }
        }
        MessagesRetrievalResult result = new MessagesRetrievalResult(messages);
        if (allMessagesOnServer) {
            result.markContainsAllStoredMessages();
        }
        return result;
    }
}

