/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.UniversalScheduler;
import pl.maciejnierzwicki.groupchat.data.ConsoleSenderTempData;
import pl.maciejnierzwicki.groupchat.integration.IVanishProvider;
import pl.maciejnierzwicki.groupchat.inventories.AdventureInventoryCreator;
import pl.maciejnierzwicki.groupchat.inventories.InventoryCreator;
import pl.maciejnierzwicki.groupchat.inventories.LegacyInventoryCreator;
import pl.maciejnierzwicki.groupchat.inventories.MessagesInventory;
import pl.maciejnierzwicki.groupchat.items.AdventureItemMetaEditor;
import pl.maciejnierzwicki.groupchat.items.ItemMetaEditor;
import pl.maciejnierzwicki.groupchat.items.LegacyItemMetaEditor;
import pl.maciejnierzwicki.groupchat.managers.Managers;
import pl.maciejnierzwicki.groupchat.managers.MessagesManager;
import pl.maciejnierzwicki.groupchat.managers.SettingsManager;
import pl.maciejnierzwicki.groupchat.messaging.AdventureMessenger;
import pl.maciejnierzwicki.groupchat.messaging.LegacyChatMessenger;
import pl.maciejnierzwicki.groupchat.messaging.Messenger;
import pl.maciejnierzwicki.groupchat.sound.SoundPlayer;
import pl.maciejnierzwicki.groupchat.storage.Storage;
import pl.maciejnierzwicki.groupchat.utils.Utils;
import pl.mirotcz.bukkit.Metrics;

public final class GroupChat
extends JavaPlugin
implements Listener {
    private Utils utils;
    private Messenger messenger;
    private InventoryCreator invCreator;
    private ItemMetaEditor itemMetaEditor;
    private Managers managers;
    private UniversalScheduler scheduler = null;
    private SoundPlayer soundPlayer = null;
    private Map<String, UUID> knownPlayersUUIDs;
    private Map<UUID, String> uuidToPlayerNamesMap;
    private volatile MessagesInventory global_history_inv = null;
    private volatile long last_global_history_inv_gen = 0L;
    private UniversalScheduler.UniversalTask cache_task = null;
    private PlayerStates playerStates = null;
    private Metrics metrics;
    private final ConsoleSenderTempData consoleSenderTempData = new ConsoleSenderTempData();
    private GroupChat instance;

    public void onEnable() {
        this.instance = this;
        this.playerStates = new PlayerStates();
        this.knownPlayersUUIDs = new HashMap<String, UUID>();
        this.uuidToPlayerNamesMap = new HashMap<UUID, String>();
        this.scheduler = new UniversalScheduler((Plugin)this.instance);
        this.utils = new Utils(this.instance);
        this.managers = new Managers(this.instance);
        this.managers.load();
        this.setupMessenger();
        this.setupInventoryCreator();
        this.setupItemMetaEditor();
        this.soundPlayer = new SoundPlayer(this.instance);
        if (!this.getManagers().getIntegrationsManager().isVanishSupported()) {
            this.getLogger().info("Vanish provider not found! Vanish support disabled.");
        } else {
            IVanishProvider vanish = this.getManagers().getIntegrationsManager().getVanish();
            this.getLogger().info("Vanish provider found! Using " + this.getManagers().getIntegrationsManager().getUsedVanishPluginName());
            this.getServer().getPluginManager().registerEvents((Listener)vanish, (Plugin)this.instance);
        }
        this.startMetricsIfEnabled();
    }

    public void onDisable() {
        this.getManagers().getPlayerSettingsManager().savePendingChanges();
        this.getManagers().getPlayerSettingsManager().cancelSaveTask();
        this.getManagers().getPendingMessagesManager().savePendingMessagesToStorage();
        this.getManagers().getPendingMessagesManager().cancelSaveTask();
        this.stopCacheTask();
        this.getStorage().closePool();
    }

    public UniversalScheduler getScheduler() {
        return this.scheduler;
    }

    public Managers getManagers() {
        return this.managers;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public MessagesManager getMessages() {
        return this.getManagers().getMessagesManager();
    }

    public SettingsManager getSettings() {
        return this.getManagers().getSettingsManager();
    }

    public Storage getStorage() {
        return this.getManagers().getStorageManager().getStorage();
    }

    public IVanishProvider getVanish() {
        return this.getManagers().getIntegrationsManager().getVanish();
    }

    public Utils getUtils() {
        return this.utils;
    }

    public PlayerStates getPlayerStates() {
        return this.playerStates;
    }

    public InventoryCreator getInventoryCreator() {
        return this.invCreator;
    }

    public ItemMetaEditor getItemMetaEditor() {
        return this.itemMetaEditor;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public ConsoleSenderTempData getConsoleSenderTempData() {
        return this.consoleSenderTempData;
    }

    public void setupMessenger() {
        this.messenger = this.getSettings().MODERN_CHAT_FORMATTING ? new AdventureMessenger() : new LegacyChatMessenger();
        this.messenger.setDefaultPrefix(this.getMessages().PLUGIN_PREFIX);
    }

    public void setupInventoryCreator() {
        this.invCreator = this.getSettings().MODERN_CHAT_FORMATTING ? new AdventureInventoryCreator() : new LegacyInventoryCreator();
    }

    public void setupItemMetaEditor() {
        this.itemMetaEditor = this.getSettings().MODERN_CHAT_FORMATTING ? new AdventureItemMetaEditor() : new LegacyItemMetaEditor();
    }

    public UUID getUUIDIfAlreadyStored(String uuidStr) {
        if (this.knownPlayersUUIDs != null && this.knownPlayersUUIDs.containsKey(uuidStr)) {
            return this.knownPlayersUUIDs.get(uuidStr);
        }
        return null;
    }

    public void addKnownPlayerUUIDIfNotStored(UUID uuid, String uuidStr) {
        if (this.knownPlayersUUIDs != null && !this.knownPlayersUUIDs.containsKey(uuidStr)) {
            this.knownPlayersUUIDs.put(uuid.toString(), uuid);
        }
    }

    public String getPlayerNameIfAlreadyStored(UUID uuid) {
        if (this.uuidToPlayerNamesMap != null && this.uuidToPlayerNamesMap.containsKey(uuid)) {
            return this.uuidToPlayerNamesMap.get(uuid);
        }
        return null;
    }

    public UUID getPlayerUUIDIfAlreadyStored(String playerName) {
        if (this.uuidToPlayerNamesMap != null) {
            for (Map.Entry<UUID, String> entry : this.uuidToPlayerNamesMap.entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void addUUIDToPlayerNameMapping(UUID uuid, String playerName) {
        if (this.uuidToPlayerNamesMap != null && !this.uuidToPlayerNamesMap.containsKey(uuid)) {
            this.uuidToPlayerNamesMap.put(uuid, playerName);
        }
    }

    public void setGlobalHistoryInv(MessagesInventory inv) {
        this.global_history_inv = inv;
    }

    public MessagesInventory getGlobalHistoryInv() {
        return this.global_history_inv;
    }

    public synchronized void setLastGlobalHistoryInvGen(long time) {
        this.last_global_history_inv_gen = time;
    }

    public long getLastGlobalHistoryInvGen() {
        return this.last_global_history_inv_gen;
    }

    public void startCacheTask() {
        this.cache_task = this.getScheduler().runSyncTimer(() -> {
            if (System.currentTimeMillis() - this.getLastGlobalHistoryInvGen() >= (long)(this.getSettings().GLOBAL_HISTORY_CACHE_TIME_SECONDS * 1000)) {
                this.clearMessagesCache();
            }
        }, 20L, 20L);
    }

    public void stopCacheTask() {
        if (this.cache_task != null) {
            this.cache_task.cancel();
        }
    }

    public void clearMessagesCache() {
        if (this.getGlobalHistoryInv() != null) {
            this.setGlobalHistoryInv(null);
        }
    }

    private void startMetricsIfEnabled() {
        if (this.getSettings().METRICS) {
            this.metrics = new Metrics(this.instance, 28246);
        }
    }
}

