/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class UniversalScheduler {
    private final Plugin plugin;
    private final Server server;
    private final boolean folia;
    private Method asyncRunNowMethod;
    private Method asyncRunDelayedMethod;
    private Method asyncRunAtFixedRateMethod;
    private Method globalRunMethod;
    private Method globalRunDelayedMethod;
    private Method globalRunAtFixedRateMethod;

    public UniversalScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.folia = this.detectFolia();
        if (this.folia) {
            try {
                Class<?> asyncScheduler = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
                Class<?> globalScheduler = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
                this.asyncRunNowMethod = asyncScheduler.getMethod("runNow", Plugin.class, Consumer.class);
                this.asyncRunDelayedMethod = asyncScheduler.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class);
                this.asyncRunAtFixedRateMethod = asyncScheduler.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class);
                this.globalRunMethod = globalScheduler.getMethod("run", Plugin.class, Consumer.class);
                this.globalRunDelayedMethod = globalScheduler.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE);
                this.globalRunAtFixedRateMethod = globalScheduler.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean detectFolia() {
        try {
            this.server.getClass().getMethod("getAsyncScheduler", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public UniversalTask runSync(Runnable task) {
        if (this.folia) {
            return this.runFoliaTask("getGlobalRegionScheduler", this.globalRunMethod, task, new Object[0]);
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTask(this.plugin, task));
    }

    public UniversalTask runSyncLater(Runnable task, long delayTicks) {
        if (this.folia) {
            return this.runFoliaTask("getGlobalRegionScheduler", this.globalRunDelayedMethod, task, delayTicks);
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks));
    }

    public UniversalTask runSyncTimer(Runnable task, long delayTicks, long periodTicks) {
        if (this.folia) {
            return this.runFoliaTask("getGlobalRegionScheduler", this.globalRunAtFixedRateMethod, task, delayTicks, periodTicks);
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTaskTimer(this.plugin, task, delayTicks, periodTicks));
    }

    public UniversalTask runAsync(Runnable task) {
        if (this.folia) {
            return this.runFoliaTask("getAsyncScheduler", this.asyncRunNowMethod, task, new Object[0]);
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task));
    }

    public UniversalTask runAsyncLater(Runnable task, long delayTicks) {
        if (this.folia) {
            return this.runFoliaTask("getAsyncScheduler", this.asyncRunDelayedMethod, task, new Object[]{delayTicks * 50L, TimeUnit.MILLISECONDS});
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delayTicks));
    }

    public UniversalTask runAsyncTimer(Runnable task, long delayTicks, long periodTicks) {
        if (this.folia) {
            return this.runFoliaTask("getAsyncScheduler", this.asyncRunAtFixedRateMethod, task, new Object[]{delayTicks * 50L, periodTicks * 50L, TimeUnit.MILLISECONDS});
        }
        return new BukkitTaskWrapper(Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, task, delayTicks, periodTicks));
    }

    private UniversalTask runFoliaTask(String schedulerGetterName, Method method, Runnable runnable, Object ... extraArgs) {
        try {
            Object scheduler = this.server.getClass().getMethod(schedulerGetterName, new Class[0]).invoke((Object)this.server, new Object[0]);
            Consumer<Object> consumer = scheduledTask -> runnable.run();
            Object[] args = new Object[extraArgs.length + 2];
            args[0] = this.plugin;
            args[1] = consumer;
            System.arraycopy(extraArgs, 0, args, 2, extraArgs.length);
            Object result = method.invoke(scheduler, args);
            return new FoliaTaskWrapper(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            runnable.run();
            return new DummyTask();
        }
    }

    public boolean isFolia() {
        return this.folia;
    }

    private static class DummyTask
    implements UniversalTask {
        private DummyTask() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }
    }

    private static class FoliaTaskWrapper
    implements UniversalTask {
        private final Object task;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        FoliaTaskWrapper(Object task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            if (!this.cancelled.getAndSet(true) && this.task != null) {
                try {
                    Method cancelMethod = this.task.getClass().getMethod("cancel", new Class[0]);
                    cancelMethod.invoke(this.task, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }

    private static class BukkitTaskWrapper
    implements UniversalTask {
        private final BukkitTask task;

        BukkitTaskWrapper(BukkitTask task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            this.task.cancel();
        }

        @Override
        public boolean isCancelled() {
            return Bukkit.getScheduler().isCurrentlyRunning(this.task.getTaskId()) && Bukkit.getScheduler().isQueued(this.task.getTaskId());
        }
    }

    public static interface UniversalTask {
        public void cancel();

        public boolean isCancelled();
    }
}

