/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.commands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.events.GroupMessageEvent;

public class SaySubCommandExecutorBase {
    private GroupChat instance;

    public SaySubCommandExecutorBase(GroupChat plugin) {
        this.instance = plugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args, boolean isShortcut) {
        this.execute(sender, args, isShortcut);
        return true;
    }

    public void execute(CommandSender sender, String[] args, boolean isShortcut) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.say")) {
                PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId());
                if (!playerSettings.areMessagesEnabled()) {
                    this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_MESSAGES_DISABLED);
                    return;
                }
                if (this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId()) != null) {
                    int i;
                    StringBuilder message = new StringBuilder();
                    int n = i = isShortcut ? 0 : 1;
                    while (i < args.length) {
                        message.append(args[i]);
                        if (i + 1 != args.length) {
                            message.append(" ");
                        }
                        ++i;
                    }
                    String msg = message.toString();
                    Group group = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (!msg.isEmpty()) {
                        if (this.instance.getUtils().getGroupUtils().getPlayerActiveMessagesGroups(pl.getUniqueId()).contains(group)) {
                            this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)pl, group, this.instance.getMessages().MESSAGE_FORMAT.replaceAll("<player>", sender.getName()).replaceAll("<message>", msg));
                            Message messageObj = new Message(pl.getUniqueId(), group.getID(), System.currentTimeMillis(), msg);
                            this.instance.getServer().getPluginManager().callEvent((Event)new GroupMessageEvent(messageObj));
                            if (this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                                this.instance.getManagers().getPendingMessagesManager().addPendingMessage(messageObj);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_NOT_ACTIVE.replaceAll("<group>", group.getName()));
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_SAY_EMPTY);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

