/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.data.InventoryLoadResult;
import pl.maciejnierzwicki.groupchat.inventories.Caller;
import pl.maciejnierzwicki.groupchat.inventories.Menu;
import pl.maciejnierzwicki.groupchat.items.ItemMetaEditor;
import pl.maciejnierzwicki.groupchat.sound.SoundConfiguration;
import pl.maciejnierzwicki.groupchat.sound.SoundConfigurationEntry;

public class SoundDetailsInventory
implements Menu {
    private List<Inventory> pages = new ArrayList<Inventory>();
    private List<Material> discs = new ArrayList<Material>();
    private Inventory parentMessagesView = null;
    private SoundConfiguration soundConfig;
    private GroupChat instance;

    public SoundDetailsInventory(GroupChat plugin, SoundConfiguration soundConfig, Inventory parentMessagesView) {
        this.instance = plugin;
        this.soundConfig = soundConfig;
        this.parentMessagesView = parentMessagesView;
        this.discs = this.instance.getUtils().getMaterialUtils().getMusicDiscsMaterials();
    }

    private SoundConfiguration getSoundConfiguration() {
        return this.soundConfig;
    }

    private ItemStack getBackToSoundsItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().BACK_ITEM);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_BACK_ITEM_DISPLAYNAME);
        is.setItemMeta(itemMeta);
        return is;
    }

    private void addBackToSoundsItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        Caller left = player -> this.instance.getScheduler().runSync(() -> {
            this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
            player.closeInventory();
            this.instance.getScheduler().runSync(() -> {
                this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_INVENTORY);
                player.openInventory(this.parentMessagesView);
            });
        });
        leftPageCallers.put(45, left);
        inv.setItem(45, this.getBackToSoundsItem());
    }

    @Override
    public InventoryLoadResult load() {
        Inventory inv = this.instance.getInventoryCreator().createInventory(null, 54, this.instance.getMessages().INV_SOUND_DETAILS_TITLE);
        this.pages = new ArrayList<Inventory>();
        List<SoundConfigurationEntry> soundEntries = this.getSoundConfiguration().getSounds();
        int count = 1;
        int allCount = 1;
        int pagesCount = 1;
        Iterator<SoundConfigurationEntry> it = soundEntries.iterator();
        HashMap<Integer, Caller> leftPageCallers = new HashMap<Integer, Caller>();
        HashMap<Integer, Caller> rightPageCallers = new HashMap<Integer, Caller>();
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemStack helpItem = new ItemStack(this.instance.getSettings().SOUND_DETAILS_HELP_ITEM_MATERIAL);
        ItemMeta helpItemMeta = helpItem.getItemMeta();
        helpItemMeta = itemMetaEditor.setDisplayName(helpItemMeta, this.instance.getMessages().INV_SOUND_DETAILS_HELP_ITEM_NAME);
        helpItemMeta = itemMetaEditor.setLore(helpItemMeta, this.instance.getMessages().INV_SOUND_DETAILS_HELP_ITEM_LORE);
        helpItem.setItemMeta(helpItemMeta);
        inv.setItem(49, helpItem);
        while (it.hasNext()) {
            Caller left;
            int finalPagesCount;
            ArrayList<String> pageItemLore;
            ItemMeta pageMeta;
            SoundConfigurationEntry soundConfigEntry = it.next();
            ItemStack item = new ItemStack(this.discs.get(this.instance.getUtils().getMainUtils().getRandomInt(0, this.discs.size() - 1)));
            ItemMeta meta = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            if (!this.instance.getMessages().INV_SOUND_ITEM_LORE.isEmpty() && !this.instance.getMessages().INV_SOUND_ITEM_LORE.stream().anyMatch(line -> line.isEmpty())) {
                lore.addAll(this.instance.getMessages().INV_SOUND_ITEM_LORE);
            }
            ArrayList<String> finalLore = new ArrayList<String>(lore);
            for (int i = 0; i < finalLore.size(); ++i) {
                finalLore.set(i, ((String)finalLore.get(i)).replaceAll("<volume>", String.valueOf(soundConfigEntry.getVolume())).replaceAll("<pitch>", String.valueOf(soundConfigEntry.getPitch())).replaceAll("<soundName>", soundConfigEntry.getSoundInternalName()).replaceAll("<pause>", String.valueOf(soundConfigEntry.getPauseAfterInTicks())));
            }
            String displayName = this.instance.getMessages().INV_SOUND_ITEM_NAME.replaceAll("<soundName>", soundConfigEntry.getSoundInternalName()).replaceAll("<soundNumber>", String.valueOf(allCount));
            meta = itemMetaEditor.setDisplayName(meta, displayName);
            meta = itemMetaEditor.setLore(meta, finalLore);
            item.setItemMeta(meta);
            inv.setItem(count - 1, item);
            Caller rightClick = player -> this.instance.getScheduler().runSync(() -> this.instance.getSoundPlayer().play(player, soundConfigEntry.getSoundInternalName(), soundConfigEntry.getVolume(), soundConfigEntry.getPitch()));
            rightPageCallers.put(count - 1, rightClick);
            if (!it.hasNext() || count == 45) {
                if (pagesCount > 1) {
                    ItemStack previousPageItem = new ItemStack(Material.ARROW);
                    pageMeta = previousPageItem.getItemMeta();
                    pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_PREVIOUS_PAGE);
                    pageItemLore = new ArrayList<String>();
                    pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount - 1)));
                    pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                    previousPageItem.setItemMeta(pageMeta);
                    finalPagesCount = pagesCount;
                    left = player -> this.instance.getScheduler().runSync(() -> {
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                        player.openInventory(this.get(finalPagesCount - 1));
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_DETAILS_INVENTORY);
                    });
                    leftPageCallers.put(52, left);
                    inv.setItem(52, previousPageItem);
                }
                inv.setItem(49, helpItem);
                this.addBackToSoundsItem(inv, leftPageCallers);
            }
            if (!it.hasNext()) {
                this.pages.add(inv);
                leftClickCallers.put(inv, leftPageCallers);
                rightClickCallers.put(inv, rightPageCallers);
                return InventoryLoadResult.SUCCESS;
            }
            if (count == 45) {
                ItemStack nextItem = new ItemStack(Material.ARROW);
                pageMeta = nextItem.getItemMeta();
                pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_NEXT_PAGE);
                pageItemLore = new ArrayList();
                pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount + 1)));
                pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                nextItem.setItemMeta(pageMeta);
                finalPagesCount = pagesCount++;
                left = player -> this.instance.getScheduler().runSync(() -> {
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                    player.openInventory(this.get(finalPagesCount + 1));
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_DETAILS_INVENTORY);
                });
                leftPageCallers.put(53, left);
                inv.setItem(53, nextItem);
                this.addBackToSoundsItem(inv, leftPageCallers);
                this.pages.add(inv);
                HashMap<Integer, Caller> finalLeftPageCallers = new HashMap<Integer, Caller>(leftPageCallers);
                HashMap finalRightPageCallers = new HashMap(rightPageCallers);
                leftClickCallers.put(inv, finalLeftPageCallers);
                rightClickCallers.put(inv, finalRightPageCallers);
                leftPageCallers = new HashMap();
                rightPageCallers = new HashMap();
                count = 1;
                inv = Bukkit.getServer().createInventory(null, 54, this.instance.getMessages().INV_SOUND_DETAILS_TITLE);
                continue;
            }
            ++count;
            ++allCount;
        }
        return InventoryLoadResult.SUCCESS;
    }

    @Override
    public Caller getLeftClickCaller(Inventory inv, int slot) {
        Map callers;
        if (leftClickCallers.containsKey(inv) && (callers = (Map)leftClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (rightClickCallers.containsKey(inv) && (callers = (Map)rightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getShiftRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (shiftRightClickCallers.containsKey(inv) && (callers = (Map)shiftRightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Inventory get(int page) {
        if (this.pages.size() >= page) {
            return this.pages.get(page - 1);
        }
        return null;
    }

    @Override
    public List<Inventory> getPages() {
        return this.pages;
    }
}

