/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.data.InventoryLoadResult;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.inventories.Caller;
import pl.maciejnierzwicki.groupchat.inventories.Menu;
import pl.maciejnierzwicki.groupchat.inventories.SoundDetailsInventory;
import pl.maciejnierzwicki.groupchat.items.ItemMetaEditor;
import pl.maciejnierzwicki.groupchat.sound.SoundConfiguration;

public class SoundInventory
implements Menu {
    private List<Inventory> pages = new ArrayList<Inventory>();
    private List<Material> discs = new ArrayList<Material>();
    private Player player;
    private GroupChat instance;

    public SoundInventory(GroupChat plugin, Player player) {
        this.instance = plugin;
        this.player = player;
        this.discs = this.instance.getUtils().getMaterialUtils().getMusicDiscsMaterials();
    }

    private Player getPlayer() {
        return this.player;
    }

    private ItemStack getExitItem() {
        ItemStack is = new ItemStack(this.instance.getSettings().EXIT_ITEM);
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta = itemMetaEditor.setDisplayName(itemMeta, this.instance.getMessages().INV_EXIT_ITEM_DISPLAYNAME);
        is.setItemMeta(itemMeta);
        return is;
    }

    private void addExitItem(Inventory inv, Map<Integer, Caller> leftPageCallers) {
        Caller left = player -> this.instance.getScheduler().runSync(() -> {
            this.instance.getPlayerStates().setState(player, PlayerStates.State.CLOSING_GUI);
            player.closeInventory();
            this.instance.getPlayerStates().setState(player, PlayerStates.State.IDLE);
        });
        leftPageCallers.put(inv.getSize() - 9, left);
        inv.setItem(inv.getSize() - 9, this.getExitItem());
    }

    @Override
    public InventoryLoadResult load() {
        Inventory inv = this.instance.getInventoryCreator().createInventory(null, 54, this.instance.getMessages().INV_SOUND_TITLE);
        this.pages = new ArrayList<Inventory>();
        Map<Integer, SoundConfiguration> soundConfigurations = this.instance.getManagers().getSoundConfigurationsManager().getConfigurationMap();
        UUID playerUUID = this.getPlayer().getUniqueId();
        PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(playerUUID);
        if (playerSettings == null) {
            this.instance.getLogger().warning("Can't create a sound inventory for player " + playerUUID.toString() + " (" + this.getPlayer().getName() + "). Player settings can't be accessed.");
            return InventoryLoadResult.PLAYER_SETTINGS_INACCESSIBLE;
        }
        int count = 1;
        int allCount = 1;
        int pagesCount = 1;
        Iterator<Map.Entry<Integer, SoundConfiguration>> it = soundConfigurations.entrySet().iterator();
        HashMap<Integer, Caller> leftPageCallers = new HashMap<Integer, Caller>();
        HashMap<Integer, Caller> rightPageCallers = new HashMap<Integer, Caller>();
        HashMap<Integer, Caller> shiftRightPageCallers = new HashMap<Integer, Caller>();
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemStack helpItem = new ItemStack(this.instance.getSettings().SOUND_HELP_ITEM_MATERIAL);
        ItemMeta helpItemMeta = helpItem.getItemMeta();
        helpItemMeta = itemMetaEditor.setDisplayName(helpItemMeta, this.instance.getMessages().INV_SOUND_HELP_ITEM_NAME);
        helpItemMeta = itemMetaEditor.setLore(helpItemMeta, this.instance.getMessages().INV_SOUND_HELP_ITEM_LORE);
        helpItem.setItemMeta(helpItemMeta);
        inv.setItem(49, helpItem);
        ItemStack toggleItem = new ItemStack(this.instance.getSettings().SOUND_TOGGLE_ITEM_MATERIAL);
        ItemMeta toggleItemMeta = toggleItem.getItemMeta();
        toggleItemMeta = itemMetaEditor.setDisplayName(toggleItemMeta, this.instance.getMessages().INV_SOUND_TOGGLE_ITEM_NAME);
        toggleItemMeta = itemMetaEditor.setLore(toggleItemMeta, this.instance.getMessages().INV_SOUND_TOGGLE_ITEM_LORE);
        toggleItem.setItemMeta(toggleItemMeta);
        inv.setItem(48, toggleItem);
        Caller toggleItemLeftClick = player -> {
            this.instance.getPlayerStates().setState(player, PlayerStates.State.CLOSING_GUI);
            PlayerSettings settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(player.getUniqueId());
            this.instance.getScheduler().runSync(() -> {
                player.closeInventory();
                if (player.hasPermission("groupchat.sound.toggle")) {
                    boolean sound_enabled = settings.isMessageNotificationSoundEnabled();
                    sound_enabled = !sound_enabled;
                    settings.setMessageNotificationSoundEnabled(sound_enabled);
                    this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(settings);
                    String sound_message = sound_enabled ? this.instance.getMessages().INFO_SOUND_NOTIFICATIONS_ENABLED : this.instance.getMessages().INFO_SOUND_NOTIFICATIONS_DISABLED;
                    this.instance.getMessenger().sendMessage((CommandSender)player, sound_message);
                } else {
                    this.instance.getMessenger().sendMessage((CommandSender)player, this.instance.getMessages().INFO_NO_PERMISSION);
                }
                this.instance.getPlayerStates().setState(player, PlayerStates.State.IDLE);
            });
        };
        if (!it.hasNext()) {
            inv.setItem(49, helpItem);
            inv.setItem(48, toggleItem);
            leftPageCallers.put(48, toggleItemLeftClick);
            this.addExitItem(inv, leftPageCallers);
            this.pages.add(inv);
            leftClickCallers.put(inv, leftPageCallers);
            rightClickCallers.put(inv, rightPageCallers);
            shiftRightClickCallers.put(inv, shiftRightPageCallers);
            return InventoryLoadResult.SUCCESS;
        }
        while (it.hasNext()) {
            Caller left;
            ArrayList<String> pageItemLore;
            ItemMeta pageMeta;
            boolean soundItemDisplayed;
            Map.Entry<Integer, SoundConfiguration> entry = it.next();
            Integer soundID = entry.getKey();
            String soundPermission = "groupchat.sound." + soundID;
            boolean playerHasPermission = this.getPlayer().hasPermission(soundPermission);
            boolean bl = soundItemDisplayed = !this.instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION || this.instance.getSettings().DISPLAY_INACCESSIBLE_SOUNDS_IN_SOUND_INVENTORY || playerHasPermission;
            if (soundItemDisplayed) {
                SoundConfiguration soundConfig = entry.getValue();
                ItemStack item = new ItemStack(this.discs.get(this.instance.getUtils().getMainUtils().getRandomInt(0, this.discs.size() - 1)));
                ItemMeta meta = item.getItemMeta();
                ArrayList<String> lore = new ArrayList<String>();
                if (soundConfig.getDescription() != null && !soundConfig.getDescription().isEmpty()) {
                    lore.addAll(soundConfig.getDescription());
                }
                ArrayList<String> finalLore = new ArrayList<String>(lore);
                if (this.instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION && !playerHasPermission) {
                    finalLore.add(" ");
                    finalLore.add(this.instance.getMessages().INFO_NO_PERMISSION);
                }
                String displayName = "";
                String soundNameToDisplayAtPlaceholder = "";
                if (soundConfig.getSounds().size() > 0) {
                    soundNameToDisplayAtPlaceholder = soundConfig.getSounds().get(0).getSoundInternalName();
                }
                displayName = soundConfig.getDisplayName() != null && !soundConfig.getDisplayName().isEmpty() ? soundConfig.getDisplayName().replaceAll("<soundName>", soundNameToDisplayAtPlaceholder).replaceAll("<soundNumber>", String.valueOf(soundConfig.getId())) : this.instance.getMessages().INV_SOUND_ITEM_NAME.replaceAll("<soundName>", soundNameToDisplayAtPlaceholder).replaceAll("<soundNumber>", String.valueOf(soundConfig.getId()));
                if (soundID.intValue() == playerSettings.getMessageNotificationSoundNumber()) {
                    displayName = displayName + this.instance.getMessages().INV_SOUND_ACTIVE_INDICATION;
                }
                meta = itemMetaEditor.setDisplayName(meta, displayName);
                meta = itemMetaEditor.setLore(meta, finalLore);
                item.setItemMeta(meta);
                inv.setItem(count - 1, item);
                Inventory finalInv = inv;
                int allFinalCount = allCount;
                Caller leftClick = player -> {
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.CLOSING_GUI);
                    this.instance.getScheduler().runSync(() -> {
                        if (this.instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION && !player.hasPermission(soundPermission)) {
                            this.instance.getMessenger().sendMessage((CommandSender)player, this.instance.getMessages().INFO_NO_PERMISSION);
                            player.closeInventory();
                            this.instance.getScheduler().runSyncLater(() -> {
                                player.openInventory(finalInv);
                                this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_INVENTORY);
                            }, 20L);
                            return;
                        }
                        PlayerSettings clickerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(player.getUniqueId());
                        int oldSoundNumber = clickerSettings.getMessageNotificationSoundNumber();
                        clickerSettings.setMessageNotificationSoundNumber(allFinalCount);
                        this.instance.getUtils().getMainUtils().sendPlayerSoundNotificationsNumberModifyEventOnNextTick(clickerSettings, oldSoundNumber, allFinalCount);
                        player.closeInventory();
                        this.instance.getMessenger().sendMessage((CommandSender)player, this.instance.getMessages().INFO_SOUND_CHANGED);
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.IDLE);
                    });
                };
                Caller rightClick = player -> this.instance.getScheduler().runSync(() -> this.instance.getSoundPlayer().play(player, soundConfig));
                Inventory f_inv = inv;
                Caller shiftRightClick = player -> this.instance.getScheduler().runAsync(() -> {
                    SoundDetailsInventory soundDetailsInventory = new SoundDetailsInventory(this.instance, soundConfig, f_inv);
                    soundDetailsInventory.load();
                    this.instance.getScheduler().runSync(() -> {
                        this.instance.getManagers().getPlayerTempDataManager().getData(playerUUID).setLastSoundDetailsInventory(soundDetailsInventory);
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                        player.closeInventory();
                        this.instance.getScheduler().runSync(() -> {
                            player.openInventory(soundDetailsInventory.get(1));
                            this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_DETAILS_INVENTORY);
                        });
                    });
                });
                leftPageCallers.put(count - 1, leftClick);
                rightPageCallers.put(count - 1, rightClick);
                shiftRightPageCallers.put(count - 1, shiftRightClick);
            }
            if (!it.hasNext() || count == 45) {
                if (pagesCount > 1) {
                    ItemStack backItem = new ItemStack(Material.ARROW);
                    pageMeta = backItem.getItemMeta();
                    pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_PREVIOUS_PAGE);
                    pageItemLore = new ArrayList<String>();
                    pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount - 1)));
                    pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                    backItem.setItemMeta(pageMeta);
                    int finalPagesCount = pagesCount;
                    left = player -> this.instance.getScheduler().runSync(() -> {
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                        player.openInventory(this.get(finalPagesCount - 1));
                        this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_INVENTORY);
                    });
                    leftPageCallers.put(52, left);
                    inv.setItem(52, backItem);
                }
                inv.setItem(49, helpItem);
                inv.setItem(48, toggleItem);
                leftPageCallers.put(48, toggleItemLeftClick);
                this.addExitItem(inv, leftPageCallers);
            }
            if (!it.hasNext()) {
                this.pages.add(inv);
                leftClickCallers.put(inv, leftPageCallers);
                rightClickCallers.put(inv, rightPageCallers);
                shiftRightClickCallers.put(inv, shiftRightPageCallers);
                return InventoryLoadResult.SUCCESS;
            }
            if (count == 45) {
                ItemStack nextItem = new ItemStack(Material.ARROW);
                pageMeta = nextItem.getItemMeta();
                pageMeta = itemMetaEditor.setDisplayName(pageMeta, this.instance.getMessages().INV_NEXT_PAGE);
                pageItemLore = new ArrayList();
                pageItemLore.add(this.instance.getMessages().INV_PAGE_NUMBER.replaceAll("<number>", String.valueOf(pagesCount + 1)));
                pageMeta = itemMetaEditor.setLore(pageMeta, pageItemLore);
                nextItem.setItemMeta(pageMeta);
                int finalPagesCount = pagesCount++;
                left = player -> this.instance.getScheduler().runSync(() -> {
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.SWITCHING_INVENTORY);
                    player.openInventory(this.get(finalPagesCount + 1));
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.WAITING_SOUND_INVENTORY);
                });
                leftPageCallers.put(53, left);
                inv.setItem(53, nextItem);
                this.addExitItem(inv, leftPageCallers);
                this.pages.add(inv);
                HashMap<Integer, Caller> finalLeftPageCallers = new HashMap<Integer, Caller>(leftPageCallers);
                HashMap finalRightPageCallers = new HashMap(rightPageCallers);
                HashMap finalShiftRightPageCallers = new HashMap(shiftRightPageCallers);
                leftClickCallers.put(inv, finalLeftPageCallers);
                rightClickCallers.put(inv, finalRightPageCallers);
                shiftRightClickCallers.put(inv, finalShiftRightPageCallers);
                leftPageCallers = new HashMap();
                rightPageCallers = new HashMap();
                shiftRightPageCallers = new HashMap();
                count = 1;
                ++allCount;
                inv = Bukkit.getServer().createInventory(null, 54, this.instance.getMessages().INV_SOUND_TITLE);
                continue;
            }
            if (!soundItemDisplayed) continue;
            ++allCount;
            ++count;
        }
        return InventoryLoadResult.SUCCESS;
    }

    @Override
    public Caller getLeftClickCaller(Inventory inv, int slot) {
        Map callers;
        if (leftClickCallers.containsKey(inv) && (callers = (Map)leftClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (rightClickCallers.containsKey(inv) && (callers = (Map)rightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Caller getShiftRightClickCaller(Inventory inv, int slot) {
        Map callers;
        if (shiftRightClickCallers.containsKey(inv) && (callers = (Map)shiftRightClickCallers.get(inv)).containsKey(slot)) {
            return (Caller)callers.get(slot);
        }
        return null;
    }

    @Override
    public Inventory get(int page) {
        if (this.pages.size() >= page) {
            return this.pages.get(page - 1);
        }
        return null;
    }

    @Override
    public List<Inventory> getPages() {
        return this.pages;
    }
}

