/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.listeners;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.events.GroupMessageEvent;

public class GroupMessageListener
implements Listener {
    private GroupChat instance;

    public GroupMessageListener(GroupChat plugin) {
        this.instance = plugin;
    }

    @EventHandler
    public void onMessage(GroupMessageEvent e) {
        this.instance.getScheduler().runAsync(() -> {
            Message message = e.getMessage();
            String senderName = this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(message.getSenderUUID());
            Group group = this.instance.getManagers().getGroupsManager().getGroup(message.getGroupID());
            String groupName = group != null ? group.getName() : "-";
            for (Player pl : Bukkit.getOnlinePlayers()) {
                PlayerSettings settings;
                if (message.getSenderUUID().equals(pl.getUniqueId()) || this.instance.getUtils().getGroupUtils().isPlayerMemberInGroup(pl, message.getGroupID()) || !pl.hasPermission("groupchat.spy") || !(settings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId())).isMessageSpyEnabled()) continue;
                this.instance.getMessenger().sendMessageWithCustomPrefix((CommandSender)pl, "", this.instance.getMessages().SPY_MESSAGE_FORMAT.replaceAll("<sender>", senderName).replaceAll("<group>", groupName).replaceAll("<message>", message.getMessageContent()));
            }
            if (this.instance.getSettings().SPY_IN_CONSOLE) {
                this.instance.getMessenger().sendMessageWithCustomPrefix((CommandSender)Bukkit.getConsoleSender(), "", this.instance.getMessages().SPY_MESSAGE_FORMAT.replaceAll("<sender>", senderName).replaceAll("<group>", groupName).replaceAll("<message>", message.getMessageContent()));
            }
        });
    }
}

