/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;
import pl.maciejnierzwicki.groupchat.inventories.Menu;
import pl.maciejnierzwicki.groupchat.staticutils.InventoryEventUtils;

public class InventoryClickListener
implements Listener {
    private GroupChat instance = null;

    public InventoryClickListener(GroupChat plugin) {
        this.instance = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle() == null) {
            return;
        }
        if (e.getView().getTitle().isEmpty()) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Inventory inv = InventoryEventUtils.getClickedInventory(e);
        if (inv == null) {
            return;
        }
        PlayerStates.State state = this.instance.getPlayerStates().getState(player);
        if (state != null && state != PlayerStates.State.IDLE) {
            e.setCancelled(true);
        }
        boolean valid_msg_inv = this.instance.getUtils().getInventoryEventUtils().isValidMessagesInventory((InventoryEvent)e, player);
        boolean valid_msg_actions_inv = this.instance.getUtils().getInventoryEventUtils().isValidMessageActionsInventory((InventoryEvent)e, player);
        boolean valid_sound_inv = this.instance.getUtils().getInventoryEventUtils().isValidSoundInventory((InventoryEvent)e, player);
        boolean valid_sound_details_inv = this.instance.getUtils().getInventoryEventUtils().isValidSoundDetailsInventory(e, player);
        if (!(valid_msg_inv || valid_msg_actions_inv || valid_sound_inv || valid_sound_details_inv)) {
            return;
        }
        e.setCancelled(true);
        this.instance.getScheduler().runAsync(() -> {
            Menu processed_menu = null;
            PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManager().getData(player.getUniqueId());
            if (valid_msg_inv) {
                processed_menu = tempData.getLastMessagesInventory();
            } else if (valid_msg_actions_inv) {
                processed_menu = tempData.getLastMessageActionsInventory();
            } else if (valid_sound_inv) {
                processed_menu = tempData.getLastSoundInventory();
            } else if (valid_sound_details_inv) {
                processed_menu = tempData.getLastSoundDetailsInventory();
            }
            if (processed_menu == null) {
                this.instance.getScheduler().runSync(() -> {
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.IDLE);
                    player.closeInventory();
                });
            }
            if (e.getClick() == ClickType.LEFT) {
                if (processed_menu.getLeftClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getLeftClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
            if (e.getClick() == ClickType.RIGHT && !e.isShiftClick()) {
                if (processed_menu.getRightClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getRightClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
            if (e.getClick() == ClickType.SHIFT_RIGHT) {
                if (processed_menu.getShiftRightClickCaller(inv, e.getSlot()) != null) {
                    processed_menu.getShiftRightClickCaller(inv, e.getSlot()).start(player);
                }
                return;
            }
        });
    }
}

