/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.listeners;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;

public class InventoryCloseListener
implements Listener {
    private GroupChat instance;
    private List<Player> pluginInvokedInventoryOpenList = new ArrayList<Player>();

    public InventoryCloseListener(GroupChat plugin) {
        this.instance = plugin;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getPlayer() instanceof Player) {
            Player player = (Player)e.getPlayer();
            if (this.pluginInvokedInventoryOpenList.contains(player)) {
                return;
            }
            if (this.instance.getPlayerStates().getState(player) != PlayerStates.State.IDLE && this.instance.getPlayerStates().getState(player) != PlayerStates.State.SWITCHING_INVENTORY && this.instance.getPlayerStates().getState(player) != PlayerStates.State.CLOSING_GUI) {
                Inventory primary_inv = e.getInventory();
                boolean valid_msg_inv = this.instance.getUtils().getInventoryEventUtils().isValidMessagesInventory((InventoryEvent)e, player);
                boolean valid_sound_inv = this.instance.getUtils().getInventoryEventUtils().isValidSoundInventory((InventoryEvent)e, player);
                boolean valid_msg_actions_inv = this.instance.getUtils().getInventoryEventUtils().isValidMessageActionsInventory((InventoryEvent)e, player);
                if (!(valid_msg_inv || valid_msg_actions_inv || valid_sound_inv)) {
                    this.instance.getPlayerStates().setState(player, PlayerStates.State.IDLE);
                    return;
                }
                this.pluginInvokedInventoryOpenList.add(player);
                this.instance.getScheduler().runSync(() -> {
                    player.openInventory(primary_inv);
                    this.instance.getScheduler().runAsync(() -> this.pluginInvokedInventoryOpenList.remove(player));
                });
            }
        }
    }
}

