/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.UniversalScheduler;
import pl.maciejnierzwicki.groupchat.data.Group;

public class GroupsManager {
    private GroupChat instance;
    private List<Group> groups = new ArrayList<Group>();
    private List<List<String>> groupsListPages = new ArrayList<List<String>>();
    private volatile BlockingQueue<Group> pendingChanges = new ArrayBlockingQueue<Group>(256);
    private UniversalScheduler.UniversalTask registeredTask = null;

    public GroupsManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public void loadAllGroupsFromStorage() {
        this.groups = this.instance.getStorage().getAllGroups();
    }

    public List<Group> getAllGroups() {
        return this.groups;
    }

    public List<List<String>> getAllGroupsChatList() {
        return this.groupsListPages;
    }

    public void loadGroupsChatList() {
        this.groupsListPages = new ArrayList<List<String>>();
        ArrayList<String> page = new ArrayList<String>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group group = this.groups.get(i);
            String line = this.instance.getMessages().GROUP_DISPLAY_LIST_FORMAT.replaceAll(this.instance.getMessages().PLUGIN_PREFIX, "").replaceAll("<number>", String.valueOf(i + 1)).replaceAll("<group>", group.getName()).replaceAll("<type>", this.instance.getUtils().getGroupUtils().getGroupTypeFormatted(group.getType())).replaceAll("<memberscount>", String.valueOf(group.getMembers().size()));
            page.add(line);
            if ((i + 1) % 10 != 0 && i + 1 != this.groups.size()) continue;
            this.groupsListPages.add(page);
            page = new ArrayList();
        }
    }

    public boolean groupExists(String groupName) {
        return this.groups.stream().anyMatch(x -> x.getName().equalsIgnoreCase(groupName));
    }

    public Group getGroup(String groupName) {
        for (Group group : this.groups) {
            if (!group.getName().equalsIgnoreCase(groupName)) continue;
            return group;
        }
        return null;
    }

    public Group getGroup(Long groupID) {
        for (Group group : this.groups) {
            if (!group.getID().equals(groupID)) continue;
            return group;
        }
        return null;
    }

    public boolean addGroup(Group group) {
        return this.groups.add(group);
    }

    public boolean removeGroup(Long groupID) {
        Iterator<Group> it = this.groups.iterator();
        while (it.hasNext()) {
            Group group = it.next();
            if (group.getID() != groupID) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public List<Group> getGroupsOwnedByPlayer(UUID playerUUID) {
        ArrayList<Group> ownedGroups = new ArrayList<Group>();
        for (Group group : this.groups) {
            if (!group.getOwner().equals(playerUUID)) continue;
            ownedGroups.add(group);
        }
        return ownedGroups;
    }

    public Long getNextGroupID() {
        Long lastID = 0L;
        for (Group group : this.getAllGroups()) {
            if (group.getID() <= lastID) continue;
            lastID = group.getID();
        }
        return lastID + 1L;
    }

    public void addPendingChanges(Group group) {
        if (!this.pendingChanges.contains(group)) {
            this.pendingChanges.add(group);
        }
    }

    public void savePendingChanges() {
        ArrayBlockingQueue<Group> queue = new ArrayBlockingQueue<Group>(256);
        queue.addAll(this.pendingChanges);
        ArrayList<Long> already_saved = new ArrayList<Long>();
        for (Group group : queue) {
            if (already_saved.stream().anyMatch(x -> x.equals(group.getID()))) continue;
            this.instance.getManagers().getStorageManager().getStorage().saveGroup(group);
            already_saved.add(group.getID());
        }
        queue.clear();
        this.pendingChanges.clear();
    }

    public void registerSaveTask() {
        this.registeredTask = this.instance.getScheduler().runAsyncTimer(() -> this.savePendingChanges(), 100L, 100L);
    }

    public void cancelSaveTask() {
        if (this.registeredTask != null) {
            this.registeredTask.cancel();
        }
    }
}

