/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.integration.IVanishProvider;
import pl.maciejnierzwicki.groupchat.integration.Integration_Essentials;
import pl.maciejnierzwicki.groupchat.integration.Integration_PremiumVanish;
import pl.maciejnierzwicki.groupchat.integration.Integration_SuperVanish;
import pl.maciejnierzwicki.groupchat.integration.Integration_Vanish_NoPacket;

public class IntegrationsManager {
    private IVanishProvider vanish = null;
    private Integration_Essentials essentials = null;
    private GroupChat instance = null;
    private static final String PREMIUMVANISH_PLUGIN = "PremiumVanish";
    private static final String SUPERVANISH_PLUGIN = "SuperVanish";
    private static final String VANISHNOPACKET_PLUGIN = "VanishNoPacket";
    private static final String ESSENTIALS_PLUGIN = "Essentials";
    private String used_vanish_plugin_name = null;

    public IntegrationsManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public void setupIntegrations() {
        if (this.instance.getServer().getPluginManager().getPlugin(PREMIUMVANISH_PLUGIN) != null) {
            try {
                this.vanish = new Integration_PremiumVanish();
                this.used_vanish_plugin_name = PREMIUMVANISH_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(PREMIUMVANISH_PLUGIN);
            }
        }
        if (this.vanish == null && this.instance.getServer().getPluginManager().getPlugin(SUPERVANISH_PLUGIN) != null) {
            try {
                this.vanish = new Integration_SuperVanish();
                this.used_vanish_plugin_name = SUPERVANISH_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(SUPERVANISH_PLUGIN);
            }
        }
        if (this.vanish == null && this.instance.getServer().getPluginManager().getPlugin(VANISHNOPACKET_PLUGIN) != null) {
            try {
                this.vanish = new Integration_Vanish_NoPacket();
                this.used_vanish_plugin_name = VANISHNOPACKET_PLUGIN;
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(VANISHNOPACKET_PLUGIN);
            }
        }
        if (this.instance.getServer().getPluginManager().getPlugin(ESSENTIALS_PLUGIN) != null) {
            try {
                this.essentials = new Integration_Essentials();
                this.sendEssentialsExtendedIntegrationEnabledMessage();
                if (this.vanish == null) {
                    this.vanish = this.essentials;
                    this.used_vanish_plugin_name = ESSENTIALS_PLUGIN;
                }
            }
            catch (NoClassDefFoundError ex) {
                this.sendVanishHookErrorMessages(ESSENTIALS_PLUGIN);
            }
        }
    }

    public IVanishProvider getVanish() {
        return this.vanish;
    }

    public boolean isVanishSupported() {
        return this.vanish != null;
    }

    public String getUsedVanishPluginName() {
        return this.used_vanish_plugin_name;
    }

    public boolean isEssentialsPresent() {
        return this.essentials != null;
    }

    public boolean isIgnoredOnEssentials(String ignored, String ignoring) {
        if (this.isEssentialsPresent()) {
            return this.essentials.isIgnored(ignored, ignoring);
        }
        return false;
    }

    public boolean isIgnoredOnAnySupportedIntegration(String ignored, String ignoring) {
        return this.isIgnoredOnEssentials(ignored, ignoring);
    }

    public List<String> getIgnoredOnEssentials(String ignoring) {
        Map<String, List<String>> all_ignores;
        if (this.isEssentialsPresent() && (all_ignores = this.essentials.getAllIgnores()).containsKey(ignoring)) {
            return all_ignores.get(ignoring);
        }
        return new ArrayList<String>();
    }

    private void sendEssentialsExtendedIntegrationEnabledMessage() {
        this.instance.getLogger().info("Enabled extended Essentials integration.");
    }

    private void sendVanishHookErrorMessages(String pluginName) {
        this.instance.getLogger().warning("GroupChat tried to hook into " + pluginName + " plugin but it looks like it hasn't loaded properly.");
        this.instance.getLogger().warning("Check for error messages related to " + pluginName + " plugin and fix all found issues.");
        this.instance.getLogger().warning("GroupChat will continue working and try to hook into other present vanish plugins.");
    }
}

