/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.commands.SayShortcutCommand;
import pl.maciejnierzwicki.groupchat.listeners.CommandListener;
import pl.maciejnierzwicki.groupchat.listeners.GroupMessageListener;
import pl.maciejnierzwicki.groupchat.listeners.GroupModifyListener;
import pl.maciejnierzwicki.groupchat.listeners.InventoryClickListener;
import pl.maciejnierzwicki.groupchat.listeners.InventoryCloseListener;
import pl.maciejnierzwicki.groupchat.listeners.PlayerSettingsModifyListener;

public class ListenersManager {
    private CommandListener cmdListener;
    private PlayerSettingsModifyListener playerSettingsModifyListener;
    private GroupModifyListener groupModifyListener;
    private InventoryClickListener invClickListener;
    private InventoryCloseListener invCloseListener;
    private GroupMessageListener groupMessageListener;
    private GroupChat instance;

    public ListenersManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public void setupListeners() {
        block5: {
            this.cmdListener = new CommandListener(this.instance);
            this.cmdListener.registerTabCompleters();
            this.instance.getCommand("groupchat").setExecutor((CommandExecutor)this.cmdListener);
            if (this.instance.getSettings().SAY_COMMAND_SHORTCUT != null && !this.instance.getSettings().SAY_COMMAND_SHORTCUT.trim().isEmpty()) {
                String shortcut = this.instance.getSettings().SAY_COMMAND_SHORTCUT;
                if (this.instance.getCommand(shortcut) != null && this.instance.getCommand(shortcut).getExecutor() != null) {
                    this.instance.getLogger().warning("Cannot register shortcut '/" + shortcut + "' for '/groupchat say' command. This shortcut is already used by " + this.instance.getCommand(shortcut).getExecutor().getClass().getName() + ". Try picking other name or fix this conflict.");
                } else {
                    try {
                        Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                        field.setAccessible(true);
                        CommandMap commandMap = (CommandMap)field.get(Bukkit.getServer());
                        SayShortcutCommand shortcutCommand = new SayShortcutCommand(shortcut);
                        shortcutCommand.load(this.instance, this.cmdListener.getSaySubCommandBase());
                        commandMap.register(shortcut, (Command)shortcutCommand);
                        HelpMap helpMap = Bukkit.getHelpMap();
                        GenericCommandHelpTopic topic = new GenericCommandHelpTopic((Command)shortcutCommand);
                        helpMap.addTopic((HelpTopic)topic);
                    }
                    catch (Exception e) {
                        this.instance.getLogger().warning("Cannot register shortcut '/" + shortcut + "' for '/groupchat say' command: " + e.getMessage());
                        e.printStackTrace();
                        break block5;
                    }
                    this.instance.getLogger().info("Registered shortcut '/" + shortcut + "' for '/groupchat say' command.");
                }
            }
        }
        this.playerSettingsModifyListener = new PlayerSettingsModifyListener(this.instance);
        this.groupModifyListener = new GroupModifyListener(this.instance);
        this.invClickListener = new InventoryClickListener(this.instance);
        this.invCloseListener = new InventoryCloseListener(this.instance);
        this.groupMessageListener = new GroupMessageListener(this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerSettingsModifyListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.groupModifyListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.invClickListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.invCloseListener, (Plugin)this.instance);
        Bukkit.getPluginManager().registerEvents((Listener)this.groupMessageListener, (Plugin)this.instance);
    }

    public CommandListener getCommandListener() {
        return this.cmdListener;
    }

    public InventoryClickListener getInventoryClickListener() {
        return this.invClickListener;
    }

    public InventoryCloseListener getInventoryCloseListener() {
        return this.invCloseListener;
    }
}

