/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.managers.FileConfigManagers;
import pl.maciejnierzwicki.groupchat.managers.GroupsManager;
import pl.maciejnierzwicki.groupchat.managers.IntegrationsManager;
import pl.maciejnierzwicki.groupchat.managers.ListenersManager;
import pl.maciejnierzwicki.groupchat.managers.MessagesManager;
import pl.maciejnierzwicki.groupchat.managers.PendingMessagesManager;
import pl.maciejnierzwicki.groupchat.managers.PlayerSettingsManager;
import pl.maciejnierzwicki.groupchat.managers.PlayerTempDataManager;
import pl.maciejnierzwicki.groupchat.managers.SettingsManager;
import pl.maciejnierzwicki.groupchat.managers.SoundConfigurationsManager;
import pl.maciejnierzwicki.groupchat.managers.StorageManager;
import pl.maciejnierzwicki.groupchat.staticutils.InvitationsManager;

public class Managers {
    private GroupChat instance;
    private FileConfigManagers configManagers;
    private SettingsManager settingsManager;
    private MessagesManager messagesManager;
    private ListenersManager listenersManager;
    private SoundConfigurationsManager soundConfigurationsManager;
    private StorageManager storageManager;
    private PlayerTempDataManager playerTempDataManager;
    private GroupsManager groupsManager;
    private PlayerSettingsManager playerSettingsManager;
    private IntegrationsManager integrationsManager;
    private PendingMessagesManager pendingMessagesManager;
    private InvitationsManager invitationsManager;

    public Managers(GroupChat plugin) {
        this.instance = plugin;
    }

    public void load() {
        this.configManagers = new FileConfigManagers(this.instance);
        this.configManagers.setupConfigs();
        this.configManagers.reloadConfigs();
        this.settingsManager = new SettingsManager(this.instance);
        this.instance.getSettings().load(this.configManagers.getMainConfigManager());
        this.messagesManager = new MessagesManager(this.instance);
        this.instance.getMessages().load(this.configManagers.getLangConfigManager());
        this.storageManager = new StorageManager(this.instance);
        this.storageManager.setupStorage();
        this.playerSettingsManager = new PlayerSettingsManager(this.instance);
        this.playerSettingsManager.loadAllFromStorage();
        this.playerSettingsManager.registerSaveTask();
        this.pendingMessagesManager = new PendingMessagesManager(this.instance);
        this.pendingMessagesManager.startSaveTask();
        this.integrationsManager = new IntegrationsManager(this.instance);
        this.integrationsManager.setupIntegrations();
        this.invitationsManager = new InvitationsManager();
        this.soundConfigurationsManager = new SoundConfigurationsManager(this.instance);
        this.soundConfigurationsManager.load();
        this.groupsManager = new GroupsManager(this.instance);
        this.groupsManager.loadAllGroupsFromStorage();
        this.groupsManager.loadGroupsChatList();
        this.groupsManager.registerSaveTask();
        this.playerTempDataManager = new PlayerTempDataManager();
        this.listenersManager = new ListenersManager(this.instance);
        this.listenersManager.setupListeners();
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public FileConfigManagers getConfigManagers() {
        return this.configManagers;
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public SoundConfigurationsManager getSoundConfigurationsManager() {
        return this.soundConfigurationsManager;
    }

    public PlayerTempDataManager getPlayerTempDataManager() {
        return this.playerTempDataManager;
    }

    public GroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public IntegrationsManager getIntegrationsManager() {
        return this.integrationsManager;
    }

    public PendingMessagesManager getPendingMessagesManager() {
        return this.pendingMessagesManager;
    }

    public InvitationsManager getInvitationsManager() {
        return this.invitationsManager;
    }
}

