/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.util.ArrayList;
import java.util.List;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.UniversalScheduler;

public class PendingMessagesManager {
    private List<Message> pending_messages = new ArrayList<Message>();
    private GroupChat instance = null;
    private UniversalScheduler.UniversalTask task = null;

    public PendingMessagesManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public List<Message> getPendingMessages() {
        return this.pending_messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            if (!this.pending_messages.contains(message)) {
                this.pending_messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingMessage(Message message) {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.remove(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingMessagesToStorage() {
        List<Message> list = this.pending_messages;
        synchronized (list) {
            this.pending_messages.forEach(message -> this.instance.getStorage().saveMessage((Message)message));
            this.pending_messages = new ArrayList<Message>();
        }
    }

    public void startSaveTask() {
        this.task = this.instance.getScheduler().runAsyncTimer(() -> this.savePendingMessagesToStorage(), this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS * 20, this.instance.getSettings().MESSAGE_SAVE_INTERVAL_SECONDS * 20);
    }

    public void cancelSaveTask() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }
}

