/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.UniversalScheduler;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class PlayerSettingsManager {
    private Map<UUID, PlayerSettings> localPlayerSettings = new HashMap<UUID, PlayerSettings>();
    private volatile BlockingQueue<PlayerSettings> pendingChanges = new ArrayBlockingQueue<PlayerSettings>(256);
    private UniversalScheduler.UniversalTask registeredTask = null;
    private GroupChat instance;

    public PlayerSettingsManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public void loadAllFromStorage() {
        List<PlayerSettings> allPlayerSettings = this.instance.getStorage().getAllPlayerSettings();
        this.localPlayerSettings = new HashMap<UUID, PlayerSettings>();
        for (PlayerSettings settings : allPlayerSettings) {
            this.localPlayerSettings.put(settings.getPlayerUUID(), settings);
        }
    }

    public void loadFromStorage(UUID uuid) {
        PlayerSettings settings = this.instance.getStorage().getPlayerSettings(uuid);
        this.localPlayerSettings.put(uuid, settings);
    }

    public PlayerSettings getPlayerSettings(UUID uuid) {
        if (this.localPlayerSettings.containsKey(uuid)) {
            return this.localPlayerSettings.get(uuid);
        }
        this.createNewSettings(uuid);
        return this.localPlayerSettings.get(uuid);
    }

    public void addPendingChanges(UUID uuid) {
        if (!this.pendingChanges.contains(this.getPlayerSettings(uuid))) {
            this.pendingChanges.add(this.getPlayerSettings(uuid));
        }
    }

    public void addPendingChanges(PlayerSettings data) {
        if (!this.pendingChanges.contains(data)) {
            this.pendingChanges.add(data);
        }
    }

    public Map<UUID, PlayerSettings> getAllSettings() {
        return this.localPlayerSettings;
    }

    public synchronized void addPlayerSettings(UUID uuid, PlayerSettings settings) {
        this.localPlayerSettings.put(uuid, settings);
    }

    public synchronized void createNewSettings(UUID uuid) {
        PlayerSettings settings = new PlayerSettings();
        settings.setPlayerUUID(uuid);
        this.localPlayerSettings.put(uuid, settings);
        this.pendingChanges.add(settings);
    }

    public synchronized void deletePlayerSettingsLocally(PlayerSettings settings) {
        Iterator<Map.Entry<UUID, PlayerSettings>> it = this.localPlayerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, PlayerSettings> entry = it.next();
            if (entry.getValue() != settings) continue;
            it.remove();
            return;
        }
    }

    public synchronized void deletePlayerSettingsLocally(UUID uuid) {
        Iterator<Map.Entry<UUID, PlayerSettings>> it = this.localPlayerSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, PlayerSettings> entry = it.next();
            if (!entry.getValue().getPlayerUUID().equals(uuid)) continue;
            it.remove();
            return;
        }
    }

    public void savePendingChanges() {
        ArrayBlockingQueue<PlayerSettings> queue = new ArrayBlockingQueue<PlayerSettings>(256);
        queue.addAll(this.pendingChanges);
        ArrayList<UUID> already_saved = new ArrayList<UUID>();
        for (PlayerSettings settings : queue) {
            if (already_saved.stream().anyMatch(x -> x.equals(settings.getPlayerUUID()))) continue;
            this.instance.getManagers().getStorageManager().getStorage().savePlayerSettings(settings);
            already_saved.add(settings.getPlayerUUID());
        }
        queue.clear();
        this.pendingChanges.clear();
    }

    public void registerSaveTask() {
        this.registeredTask = this.instance.getScheduler().runAsyncTimer(() -> this.savePendingChanges(), 100L, 100L);
    }

    public void cancelSaveTask() {
        if (this.registeredTask != null) {
            this.registeredTask.cancel();
        }
    }

    public void reloadSettings(UUID uuid) {
        if (uuid == null) {
            return;
        }
        PlayerSettings settings = this.getPlayerSettings(uuid);
        if (settings == null) {
            return;
        }
        PlayerSettings updated_settings = this.instance.getStorage().getPlayerSettings(uuid);
        if (updated_settings != null) {
            UUID p_uuid = updated_settings.getPlayerUUID();
            Long current_group_id = updated_settings.getCurrentGroupID();
            Set<Long> active_groups = updated_settings.getActiveGroups();
            int sound_number = updated_settings.getMessageNotificationSoundNumber();
            boolean sound_enabled = updated_settings.isMessageNotificationSoundEnabled();
            boolean spy_enabled = updated_settings.isMessageSpyEnabled();
            boolean msg_enabled = updated_settings.areMessagesEnabled();
            boolean tips_enabled = updated_settings.arePluginTipsEnabled();
            int notification_sound_tips_count = updated_settings.getNotificationSoundTipsCount();
            this.instance.getScheduler().runSync(() -> settings.load(p_uuid, current_group_id, active_groups, sound_number, sound_enabled, spy_enabled, msg_enabled, tips_enabled, notification_sound_tips_count));
        }
    }

    public boolean playerSettingsExists(UUID uuid) {
        return this.localPlayerSettings.containsKey(uuid);
    }
}

