/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.managers.FileConfigManager;

public class SettingsManager {
    public int MAX_OWNED_GROUPS;
    public int MAX_MEMBER_GROUPS;
    public boolean COMMAND_SAY_ALIAS_ENABLED;
    public String COMMAND_SAY_ALIAS;
    public boolean SOUND_ENABLED;
    public String SOUND_NAME;
    public float SOUND_VOL;
    public float SOUND_PITCH;
    public String STORAGE_TYPE;
    public String DB_HOST;
    public String DB_NAME;
    public String DB_USER;
    public String DB_PASS;
    public int DB_PORT;
    public boolean MODERN_CHAT_FORMATTING = false;
    public boolean METRICS = true;
    public Material BACK_ITEM = Material.REDSTONE_BLOCK;
    public Material EXIT_ITEM = Material.REDSTONE_BLOCK;
    public Material SOUND_DETAILS_HELP_ITEM_MATERIAL = Material.PAPER;
    public Material SOUND_HELP_ITEM_MATERIAL = Material.PAPER;
    public Material SOUND_TOGGLE_ITEM_MATERIAL = Material.LEVER;
    public boolean EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION = false;
    public boolean DISPLAY_INACCESSIBLE_SOUNDS_IN_SOUND_INVENTORY = true;
    public boolean SPY_IN_CONSOLE = true;
    public boolean PLUGIN_TIPS = true;
    public int PLUGIN_TIPS_MODE = 1;
    public DateTimeFormatter MESSAGES_HISTORY_DATETIME_FORMATTER;
    public List<DateTimeFormatter> IN_COMMAND_DATETIME_FORMATTERS;
    public List<String> IN_COMMAND_DATETIME_FORMAT_PLAIN;
    public String TIME_ZONE;
    public int MESSAGE_SAVE_INTERVAL_SECONDS = 10;
    public int MAX_HISTORY_MESSAGES_PER_SECOND = 5000;
    public boolean MESSAGES_HISTORY_ENABLED = true;
    public Material MESSAGE_ITEM_MATERIAL = Material.PAPER;
    public int GLOBAL_HISTORY_CACHE_TIME_SECONDS = 600;
    public Material MESSAGE_ACTION_DELETE_ITEM_MATERIAL = Material.LAVA_BUCKET;
    public boolean MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = true;
    public boolean MESSAGES_DELETION_BY_INVENTORY_REQUIRES_CONFIRMATION = true;
    public boolean ESSENTIALS_IGNORE_RESPECT = true;
    public int GROUP_SHORTNAME_MAXLENGTH = 10;
    public int GROUP_DISPLAYNAME_MAXLENGTH = 30;
    public int GROUP_DESCRIPTION_MAXLENGTH = 50;
    public String SAY_COMMAND_SHORTCUT = "g";
    public boolean ANNOUNCE_PLAYER_GROUP_SWITCH = true;
    public boolean AUTO_SWITCH_GROUP_ON_LEAVE = true;
    public boolean AUTO_SWITCH_GROUP_ON_KICK_AND_BAN = true;
    public String SPACE_CODE_IN_COMMANDS = "<_>";
    private GroupChat instance;

    public SettingsManager(GroupChat plugin) {
        this.instance = plugin;
    }

    public void load(FileConfigManager config) {
        this.MAX_OWNED_GROUPS = config.getConfig().getInt("MaxOwnedGroups");
        this.MAX_MEMBER_GROUPS = config.getConfig().getInt("MaxMemberGroups");
        this.COMMAND_SAY_ALIAS_ENABLED = config.getConfig().getBoolean("SayCommandAlias.enabled");
        this.COMMAND_SAY_ALIAS = config.getConfig().getString("SayCommandAlias.alias");
        this.SOUND_ENABLED = config.getConfig().getBoolean("Sound.enabled");
        this.SOUND_NAME = config.getConfig().getString("Sound.SoundName");
        this.SOUND_VOL = (float)config.getConfig().getDouble("Sound.Volume");
        this.SOUND_PITCH = (float)config.getConfig().getDouble("Sound.Pitch");
        this.STORAGE_TYPE = config.getConfig().getString("Storage.type");
        this.DB_HOST = config.getConfig().getString("Storage.hostname");
        this.DB_NAME = config.getConfig().getString("Storage.database");
        this.DB_USER = config.getConfig().getString("Storage.user");
        this.DB_PASS = config.getConfig().getString("Storage.password");
        this.DB_PORT = config.getConfig().getInt("Storage.port");
        this.ESSENTIALS_IGNORE_RESPECT = config.getConfig().getBoolean("Integration.Essentials.RespectIgnore");
        this.MODERN_CHAT_FORMATTING = config.getConfig().getBoolean("ModernChatFormatting");
        this.METRICS = config.getConfig().getBoolean("Metrics");
        this.BACK_ITEM = Material.valueOf((String)config.getConfig().getString("BackItem"));
        this.EXIT_ITEM = Material.valueOf((String)config.getConfig().getString("ExitItem"));
        this.SOUND_DETAILS_HELP_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundDetailsHelpItem"));
        this.SOUND_HELP_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundHelpItem"));
        this.SOUND_TOGGLE_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("SoundToggleItem"));
        this.EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION = config.getConfig().getBoolean("EachNotificationSoundRequiresPermission");
        this.DISPLAY_INACCESSIBLE_SOUNDS_IN_SOUND_INVENTORY = config.getConfig().getBoolean("DisplayInaccessibleSoundsInSoundInventory");
        this.SPY_IN_CONSOLE = config.getConfig().getBoolean("SpyInConsole");
        this.PLUGIN_TIPS = config.getConfig().getBoolean("PluginTips.Enabled");
        this.PLUGIN_TIPS_MODE = config.getConfig().getInt("PluginTips.Mode");
        this.TIME_ZONE = config.getConfig().contains("MessagesHistory.TimeZone") ? config.getConfig().getString("MessagesHistory.TimeZone") : config.getConfig().getString("TimeZone");
        try {
            ZoneId.of(this.TIME_ZONE);
        }
        catch (DateTimeException ex) {
            this.instance.getLogger().warning("Invalid time zone: " + this.TIME_ZONE + ". Using default zone (Europe/Warsaw).");
            this.TIME_ZONE = "Europe/Warsaw";
        }
        this.IN_COMMAND_DATETIME_FORMAT_PLAIN = config.getConfig().getStringList("InCommandDateTimeFormat");
        this.IN_COMMAND_DATETIME_FORMATTERS = new ArrayList<DateTimeFormatter>();
        for (String formatPlain : this.IN_COMMAND_DATETIME_FORMAT_PLAIN) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(formatPlain).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
            this.IN_COMMAND_DATETIME_FORMATTERS.add(formatter);
        }
        this.MESSAGES_HISTORY_ENABLED = config.getConfig().getBoolean("MessagesHistory.Enabled");
        this.MESSAGES_HISTORY_DATETIME_FORMATTER = DateTimeFormatter.ofPattern(config.getConfig().getString("MessagesHistory.DateFormat")).withZone(ZoneId.of(this.TIME_ZONE));
        this.MESSAGE_SAVE_INTERVAL_SECONDS = config.getConfig().getInt("MessagesSaveIntervalSeconds");
        this.MAX_HISTORY_MESSAGES_PER_SECOND = config.getConfig().getInt("MaxHistoryMessagesPerSecond");
        this.GLOBAL_HISTORY_CACHE_TIME_SECONDS = config.getConfig().getInt("GlobalHistoryCacheTimeSeconds");
        this.MESSAGE_ACTION_DELETE_ITEM_MATERIAL = Material.valueOf((String)config.getConfig().getString("MessageActionDeleteItem"));
        this.MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION = config.getConfig().getBoolean("MessagesDeletionByCommandRequiresConfirmation");
        this.MESSAGES_DELETION_BY_INVENTORY_REQUIRES_CONFIRMATION = config.getConfig().getBoolean("MessagesDeletionByInventoryRequiresConfirmation");
        Material messageItem = null;
        try {
            this.MESSAGE_ITEM_MATERIAL = messageItem = Material.valueOf((String)config.getConfig().getString("MessageItem"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.GROUP_SHORTNAME_MAXLENGTH = config.getConfig().getInt("GroupShortNameMaxLength");
        this.GROUP_DISPLAYNAME_MAXLENGTH = config.getConfig().getInt("GroupDisplayNameMaxLength");
        this.GROUP_DESCRIPTION_MAXLENGTH = config.getConfig().getInt("GroupDescriptionMaxLength");
        this.SAY_COMMAND_SHORTCUT = config.getConfig().getString("SayCommandShortcut");
        this.ANNOUNCE_PLAYER_GROUP_SWITCH = config.getConfig().getBoolean("AnnouncePlayerGroupSwitch");
        this.AUTO_SWITCH_GROUP_ON_LEAVE = config.getConfig().getBoolean("AutoSwitchActiveGroupOnLeave");
        this.AUTO_SWITCH_GROUP_ON_KICK_AND_BAN = config.getConfig().getBoolean("AutoSwitchActiveGroupOnKickAndBan");
        this.SPACE_CODE_IN_COMMANDS = config.getConfig().getString("SpaceCodeInCommands");
    }

    public void save() {
        FileConfigManager config = this.instance.getManagers().getConfigManagers().getMainConfigManager();
        config.getConfig().set("SpyInConsole", (Object)this.SPY_IN_CONSOLE);
        config.saveConfig();
        config.reloadConfig();
    }
}

