/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.SoundConstructionResult;
import pl.maciejnierzwicki.groupchat.managers.FileConfigManager;
import pl.maciejnierzwicki.groupchat.sound.SoundConfiguration;
import pl.maciejnierzwicki.groupchat.sound.SoundConfigurationEntry;

public class SoundConfigurationsManager {
    private Map<Integer, SoundConfiguration> soundConfigurations = new HashMap<Integer, SoundConfiguration>();
    private GroupChat instance;

    public SoundConfigurationsManager(GroupChat plugin) {
        this.instance = plugin;
    }

    private boolean isValidSoundName(String soundName) {
        if (soundName == null) {
            return false;
        }
        try {
            Sound.valueOf((String)soundName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private SoundConstructionResult getSoundFromString(String text) {
        String[] parentEntries;
        if (text == null || text.isEmpty()) {
            return new SoundConstructionResult(new ArrayList<SoundConfigurationEntry>(), Arrays.asList("Sound construction text is empty!"));
        }
        ArrayList<SoundConfigurationEntry> sounds = new ArrayList<SoundConfigurationEntry>();
        for (String entry : parentEntries = text.split(";")) {
            String internalSoundName;
            boolean isShortSoundFormat;
            String[] childEntries = entry.split(",");
            boolean bl = isShortSoundFormat = childEntries.length == 1;
            if (isShortSoundFormat) {
                internalSoundName = childEntries[0];
            } else {
                if (childEntries.length < 3 || childEntries.length > 4) {
                    return new SoundConstructionResult(new ArrayList<SoundConfigurationEntry>(), Arrays.asList("Invalid parameters length for sound entry! Required 3-4 parameters. Processed text: " + entry));
                }
                internalSoundName = childEntries[0];
            }
            if (!this.isValidSoundName(internalSoundName)) {
                return new SoundConstructionResult(new ArrayList<SoundConfigurationEntry>(), Arrays.asList("Invalid in-game sound identifier for sound entry! Processed text: " + entry));
            }
            float volume = 1.0f;
            float pitch = 1.0f;
            long delayAfter = 0L;
            if (!isShortSoundFormat) {
                try {
                    volume = Float.valueOf(childEntries[1]).floatValue();
                    pitch = Float.valueOf(childEntries[2]).floatValue();
                    if (childEntries.length == 4) {
                        delayAfter = Long.valueOf(childEntries[3]);
                    }
                }
                catch (NumberFormatException e) {
                    return new SoundConstructionResult(new ArrayList<SoundConfigurationEntry>(), Arrays.asList("Invalid value of volume/pitch/delay for sound entry! Processed text: " + entry));
                }
            }
            SoundConfigurationEntry soundEntry = new SoundConfigurationEntry(internalSoundName, volume, pitch, delayAfter);
            sounds.add(soundEntry);
        }
        return new SoundConstructionResult(sounds);
    }

    public void load() {
        this.soundConfigurations = new HashMap<Integer, SoundConfiguration>();
        FileConfigManager config = this.instance.getManagers().getConfigManagers().getSoundsConfigManager();
        for (String number : config.getConfig().getKeys(false)) {
            Integer id;
            ConfigurationSection soundSection = config.getConfig().getConfigurationSection(number);
            try {
                id = Integer.valueOf(number);
            }
            catch (NumberFormatException e) {
                this.instance.getLogger().warning("Cannot load configuration for sound with ID \"" + number + "\". ID has to be a number!");
                continue;
            }
            String soundDescriptor = soundSection.contains("SoundName") ? soundSection.getString("SoundName") : soundSection.getString("Sound");
            String displayName = null;
            List description = null;
            if (soundSection.contains("DisplayName")) {
                displayName = soundSection.getString("DisplayName");
            }
            if (soundSection.contains("Description")) {
                description = soundSection.getStringList("Description");
            }
            SoundConfiguration soundConfig = null;
            SoundConstructionResult constructionResult = this.getSoundFromString(soundDescriptor);
            if (constructionResult.hasErrors()) {
                this.instance.getLogger().warning("Cannot load configuration for sound with ID \"" + number + "\". Check details in next message.");
                constructionResult.getErrors().forEach(error -> this.instance.getLogger().warning((String)error));
                continue;
            }
            List<SoundConfigurationEntry> sounds = constructionResult.getSounds();
            soundConfig = new SoundConfiguration(id, sounds, displayName, description);
            this.soundConfigurations.put(id, soundConfig);
        }
    }

    public boolean containsConfiguration(Integer id) {
        return this.soundConfigurations.containsKey(id);
    }

    public SoundConfiguration getConfiguration(Integer id) {
        return this.soundConfigurations.get(id);
    }

    public Map<Integer, SoundConfiguration> getConfigurationMap() {
        return this.soundConfigurations;
    }
}

