/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.messaging;

import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.bukkit.command.CommandSender;
import pl.maciejnierzwicki.groupchat.messaging.Messenger;
import pl.maciejnierzwicki.groupchat.staticutils.ChatCompatUtil;

public class AdventureMessenger
implements Messenger {
    private final MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.builder().resolver(StandardTags.color()).resolver(StandardTags.decorations()).resolver(StandardTags.reset()).build()).build();
    private String prefix = "";

    @Override
    public void setDefaultPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void sendMessage(CommandSender recipient, String message) {
        message = message.replace("\u00a7", "&").replace("&", "&amp;");
        Object component = this.miniMessage.deserialize(this.prefix + message);
        ChatCompatUtil.send(recipient, null, component);
    }

    @Override
    public void sendMessageWithCustomPrefix(CommandSender recipient, String message, String customPrefix) {
        message = message.replace("\u00a7", "&").replace("&", "&amp;");
        Object component = this.miniMessage.deserialize(customPrefix + message);
        ChatCompatUtil.send(recipient, null, component);
    }

    @Override
    public void sendMessage(CommandSender recipient, List<String> messages) {
        messages.forEach(msg -> this.sendMessage(recipient, (String)msg));
    }

    @Override
    public void sendMessageWithCustomPrefix(CommandSender recipient, List<String> messages, String customPrefix) {
        messages.forEach(msg -> this.sendMessageWithCustomPrefix(recipient, (String)msg, customPrefix));
    }
}

