/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.sound;

import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.sound.SoundConfiguration;
import pl.maciejnierzwicki.groupchat.sound.SoundConfigurationEntry;

public class SoundPlayer {
    private GroupChat instance;

    public SoundPlayer(GroupChat plugin) {
        this.instance = plugin;
    }

    public void play(Player player, String name, float volume, float pitch) {
        player.playSound(player.getLocation(), Sound.valueOf((String)name), volume, pitch);
    }

    private void play(Player player, List<SoundConfigurationEntry> sounds) {
        long accumulatedDelay = 0L;
        for (SoundConfigurationEntry soundEntry : sounds) {
            if (accumulatedDelay > 0L) {
                this.instance.getScheduler().runSyncLater(() -> this.play(player, soundEntry.getSoundInternalName(), soundEntry.getVolume(), soundEntry.getPitch()), accumulatedDelay);
            } else {
                this.play(player, soundEntry.getSoundInternalName(), soundEntry.getVolume(), soundEntry.getPitch());
            }
            if (soundEntry.getPauseAfterInTicks() <= 0L) continue;
            accumulatedDelay += soundEntry.getPauseAfterInTicks();
        }
    }

    public void play(Player player, SoundConfiguration soundConfig) {
        this.play(player, soundConfig.getSounds());
    }
}

