/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.staticutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InvCompatUtil {
    private static final boolean ADVENTURE_AVAILABLE;
    private static final Method CREATE_INVENTORY_METHOD;

    public static Inventory createInventory(InventoryHolder invHolder, int size, String legacyTitle, Object adventureComponent) {
        if (ADVENTURE_AVAILABLE && adventureComponent != null) {
            try {
                Inventory inv = (Inventory)CREATE_INVENTORY_METHOD.invoke(null, invHolder, size, adventureComponent);
                return inv;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (legacyTitle != null) {
            return Bukkit.createInventory((InventoryHolder)invHolder, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)legacyTitle));
        }
        return null;
    }

    static {
        boolean found = false;
        Method method = null;
        try {
            Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
            method = Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, componentClass);
            found = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        ADVENTURE_AVAILABLE = found;
        CREATE_INVENTORY_METHOD = method;
    }
}

