/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.staticutils;

import org.bukkit.Bukkit;

public class ServerUtils {
    public static String getServerVersion() {
        String version;
        try {
            version = Bukkit.getBukkitVersion().split("-")[0];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return null;
        }
        return version;
    }

    public static boolean isMinecraftVersionAtLeast(String versionStr) {
        return ServerUtils.compareVersions(ServerUtils.getServerVersion(), versionStr) >= 0;
    }

    private static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }
}

