/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.UUID;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.DateRelationType;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public interface Storage {
    public void setupTables();

    public Group getGroup(Long var1);

    public List<Group> getAllGroups();

    public boolean groupExists(Long var1);

    public Group saveGroup(Group var1);

    public void deleteGroup(Long var1);

    public PlayerSettings getPlayerSettings(UUID var1);

    public List<PlayerSettings> getAllPlayerSettings();

    public boolean playerSettingsExists(UUID var1);

    public void savePlayerSettings(PlayerSettings var1);

    public void deletePlayerSettings(PlayerSettings var1);

    public List<Message> getMessagesFromHistory(Iterable<Long> var1);

    public List<Message> getMessagesFromHistoryRelativeToDate(Long var1, DateRelationType var2);

    public List<Message> getMessagesFromHistoryInDatesRange(Long var1, Long var2);

    public List<Message> getGroupMessagesFromHistoryRelativeToDate(Long var1, String var2, Long var3, DateRelationType var4);

    default public List<Message> getGroupMessagesFromHistoryRelativeToDate(Long groupID, Long timestamp, DateRelationType dateRelationType) {
        return this.getGroupMessagesFromHistoryRelativeToDate(groupID, null, timestamp, dateRelationType);
    }

    default public List<Message> getGroupMessagesFromHistoryRelativeToDate(String playerUUID, Long timestamp, DateRelationType dateRelationType) {
        return this.getGroupMessagesFromHistoryRelativeToDate(null, playerUUID, timestamp, dateRelationType);
    }

    public List<Message> getGroupMessagesFromHistoryInDatesRange(Long var1, String var2, Long var3, Long var4);

    default public List<Message> getGroupMessagesFromHistoryInDatesRange(Long groupID, Long startTimestamp, Long endTimestamp) {
        return this.getGroupMessagesFromHistoryInDatesRange(groupID, null, startTimestamp, endTimestamp);
    }

    default public List<Message> getGroupMessagesFromHistoryInDatesRange(String playerUUID, Long startTimestamp, Long endTimestamp) {
        return this.getGroupMessagesFromHistoryInDatesRange(null, playerUUID, startTimestamp, endTimestamp);
    }

    public List<Message> getGroupMessagesFromHistory(Long var1, String var2);

    default public List<Message> getGroupMessagesFromHistory(Long groupID) {
        return this.getGroupMessagesFromHistory(groupID, null);
    }

    default public List<Message> getGroupMessagesFromHistory(String playerUUID) {
        return this.getGroupMessagesFromHistory(null, playerUUID);
    }

    public List<Message> getAllMessagesFromHistory();

    public Message getMessageFromHistory(Long var1);

    public void saveMessage(Message var1);

    public boolean messageExists(Long var1);

    public void deleteGroupMessages(Long var1);

    public void deleteMessages(List<Message> var1);

    public void deleteMessage(Long var1);

    public void deleteAllMessages();

    public void close(Connection var1, PreparedStatement var2, ResultSet var3);

    public void closePool();
}

