/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.DateRelationType;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.GroupType;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.storage.Storage;
import pl.maciejnierzwicki.groupchat.storage.data.SchemaRetrievalResult;
import pl.maciejnierzwicki.groupchat.utils.Utils;

public class Storage_SQLite
implements Storage {
    private GroupChat instance;
    private HikariConfig config;
    private HikariDataSource ds;
    volatile Connection conn;
    private final int latest_schema_version = 1;
    String groups_table_create_query = "CREATE TABLE IF NOT EXISTS groupchat_groups (\n id integer PRIMARY KEY,\n\tgroup_name text NOT NULL,\n\tgroup_displayname text NOT NULL,\n group_type text NOT NULL,\n group_description text,\n\tgroup_owner text NOT NULL,\n group_members text NOT NULL,\n banned_players text\n);";
    String players_table_create_query = "CREATE TABLE IF NOT EXISTS groupchat_players (\n player_id text PRIMARY KEY,\n\tcurrent_group_id integer DEFAULT -1,\n active_messages_groups text,\n sound_enabled integer DEFAULT 1,\n sound_number integer DEFAULT 1,\n spy_enabled integer,\n messages_enabled integer DEFAULT 1,\n plugin_tips_enabled integer DEFAULT 1,\n notification_sound_tips_count integer DEFAULT 0\n);";
    String messages_table_create_query = "CREATE TABLE IF NOT EXISTS groupchat_messages (\n id integer PRIMARY KEY,\n group_id integer NOT NULL,\n sender_id text NOT NULL,\n\tsent_date integer NOT NULL,\n\tmessage text NOT NULL\n);";
    private String schema_table_creation_query = "CREATE TABLE IF NOT EXISTS groupchat_schema_version (\n\tSCHEMA_VERSION INT(6) DEFAULT 1\n);";

    public Storage_SQLite(GroupChat plugin) {
        this.instance = plugin;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e1) {
            this.instance.getLogger().warning(e1.getMessage());
        }
        this.config = new HikariConfig();
        this.config.setPoolName("GroupChatSQLitePool");
        this.config.setDriverClassName("org.sqlite.JDBC");
        this.config.setJdbcUrl("jdbc:sqlite:plugins/GroupChat/Storage.db");
        this.config.setConnectionTestQuery("SELECT 1");
        this.config.addDataSourceProperty("cachePrepStmts", "true");
        this.config.addDataSourceProperty("prepStmtCacheSize", "250");
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.config.addDataSourceProperty("useServerPrepStmts", true);
        this.config.addDataSourceProperty("characterEncoding", "utf8");
        this.config.addDataSourceProperty("useUnicode", true);
        this.config.setLeakDetectionThreshold(10000L);
        this.config.setMaximumPoolSize(1);
        this.config.setMinimumIdle(1);
        this.ds = new HikariDataSource(this.config);
        this.setupTables();
    }

    private String getSchemaTableInsertQueryForVersion(int value) {
        return "INSERT INTO groupchat_schema_version (SCHEMA_VERSION) VALUES (" + value + ");";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaTable(int version) {
        String delete_query = "DELETE FROM groupchat_schema_version";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(delete_query);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.getSchemaTableInsertQueryForVersion(version));
            ps.execute();
            ps.close();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(String table_name) {
        boolean table_exists = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + table_name + "'";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            table_exists = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return table_exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaRetrievalResult getStoredSchema() {
        SchemaRetrievalResult schema = new SchemaRetrievalResult();
        int stored_schema_version = 0;
        if (!this.tableExists("groupchat_schema_version")) {
            schema.setVersion(stored_schema_version);
            return schema;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_schema_version";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                stored_schema_version = rs.getInt("SCHEMA_VERSION");
                schema.setIsPresent(true);
                schema.setVersion(stored_schema_version);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOldTablesIfNeeded(SchemaRetrievalResult schema) {
        int existing_schema_version = schema.getVersion();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_schema_version";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                existing_schema_version = rs.getInt("SCHEMA_VERSION");
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() != 1146) {
                    e.printStackTrace();
                }
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public void setupTables() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            SchemaRetrievalResult schema = this.getStoredSchema();
            if (!schema.isPresent()) {
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(this.schema_table_creation_query);
                ps.executeUpdate();
                ps.close();
                conn.close();
                this.updateSchemaTable(1);
            } else {
                this.updateOldTablesIfNeeded(schema);
            }
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.groups_table_create_query);
            ps.executeUpdate();
            ps = conn.prepareStatement(this.players_table_create_query);
            ps.executeUpdate();
            ps = conn.prepareStatement(this.messages_table_create_query);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            this.close(conn, ps, null);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group saveGroup(Group group) {
        boolean update = this.groupExists(group.getID());
        String sql = update ? "UPDATE groupchat_groups SET group_name = ?, group_displayname = ?, group_owner = ?, group_members = ?, group_description = ?, group_type = ?, banned_players = ? WHERE id = ?" : "INSERT INTO groupchat_groups (group_name, group_displayname, group_owner, group_members, group_description, group_type, banned_players, id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, group.getName());
            ps.setString(2, group.getDisplayName());
            ps.setString(3, group.getOwner().toString());
            ps.setString(4, group.getMembers().toString());
            ps.setString(5, group.getDescription());
            ps.setString(6, group.getType().toString());
            ps.setString(7, group.getBannedPlayers().toString());
            ps.setLong(8, group.getID());
            ps.executeUpdate();
            Group group2 = group;
            this.close(conn, ps, null);
            return group2;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                Group group3 = group;
                this.close(conn, ps, null);
                return group3;
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getGroup(Long groupID) {
        Group group = null;
        String sql = "SELECT * FROM groupchat_groups WHERE id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String groupName = "";
        String groupDisplayName = "";
        String groupDescription = "";
        HashSet<UUID> groupMembers = new HashSet<UUID>();
        HashSet<UUID> groupBannedPlayers = new HashSet<UUID>();
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, groupID);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                groupName = rs.getString("group_name");
                groupDisplayName = rs.getString("group_displayname");
                groupDescription = rs.getString("group_description");
                UUID groupOwner = this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("group_owner"));
                GroupType groupType = GroupType.valueOf(rs.getString("group_type"));
                String[] membersList = rs.getString("group_members").replace("[", "").replace("]", "").split(", ");
                String[] bannedList = rs.getString("banned_players").replace("[", "").replace("]", "").split(", ");
                for (String memberUUID : membersList) {
                    if (memberUUID.isEmpty()) continue;
                    groupMembers.add(this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(memberUUID));
                }
                for (String bannedUUID : bannedList) {
                    if (bannedUUID.isEmpty()) continue;
                    groupBannedPlayers.add(this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(bannedUUID));
                }
                group = new Group(groupOwner, groupName);
                group.setDisplayName(groupDisplayName);
                group.setDescription(groupDescription);
                group.setID(groupID);
                group.setMembers(groupMembers);
                group.setBannedPlayers(groupBannedPlayers);
                group.setType(groupType);
            }
            this.close(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, rs);
                throw throwable;
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean groupExists(Long groupID) {
        String sql = "SELECT * FROM groupchat_groups WHERE id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, groupID);
            rs = ps.executeQuery();
            boolean bl = rs.isBeforeFirst();
            this.close(conn, ps, rs);
            return bl;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                boolean bl = false;
                this.close(conn, ps, rs);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(conn, ps, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getAllGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        String sql = "SELECT * FROM groupchat_groups ORDER BY id ASC";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                Long groupID = rs.getLong("id");
                String groupName = rs.getString("group_name");
                String groupDisplayName = rs.getString("group_displayname");
                String groupDescription = rs.getString("group_description");
                UUID groupOwner = this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("group_owner"));
                GroupType groupType = GroupType.valueOf(rs.getString("group_type"));
                HashSet<UUID> groupMembers = new HashSet<UUID>();
                HashSet<UUID> groupBannedPlayers = new HashSet<UUID>();
                String[] membersList = rs.getString("group_members").replace("[", "").replace("]", "").split(", ");
                String[] bannedList = rs.getString("banned_players").replace("[", "").replace("]", "").split(", ");
                for (String memberUUID : membersList) {
                    if (memberUUID.isEmpty()) continue;
                    groupMembers.add(this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(memberUUID));
                }
                for (String bannedUUID : bannedList) {
                    if (bannedUUID.isEmpty()) continue;
                    groupBannedPlayers.add(this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(bannedUUID));
                }
                Group group = new Group(groupOwner, groupName);
                group.setDisplayName(groupDisplayName);
                group.setDescription(groupDescription);
                group.setType(groupType);
                group.setMembers(groupMembers);
                group.setBannedPlayers(groupBannedPlayers);
                group.setID(groupID);
                groups.add(group);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(Long groupID) {
        String sql = "DELETE FROM groupchat_groups WHERE id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, groupID);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlayerSettings> getAllPlayerSettings() {
        ArrayList<PlayerSettings> allPlayersSettings = new ArrayList<PlayerSettings>();
        String sql = "SELECT * FROM groupchat_players";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                Long currentGroupID = rs.getLong("current_group_id");
                UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("player_id"));
                String[] activeGroupsStr = rs.getString("active_messages_groups").replace("[", "").replace("]", "").split(", ");
                HashSet<Long> activeGroups = new HashSet<Long>();
                for (String groupStr : activeGroupsStr) {
                    if (!Utils.isLong(groupStr)) continue;
                    activeGroups.add(Long.parseLong(groupStr));
                }
                PlayerSettings settings = new PlayerSettings();
                boolean soundEnabled = Utils.getBooleanFromInt(rs.getInt("sound_enabled"));
                Integer soundNumber = rs.getInt("sound_number");
                boolean spyEnabled = Utils.getBooleanFromInt(rs.getInt("spy_enabled"));
                boolean messagesEnabled = Utils.getBooleanFromInt(rs.getInt("messages_enabled"));
                boolean pluginTipsEnabled = Utils.getBooleanFromInt(rs.getInt("plugin_tips_enabled"));
                Integer notificationSoundTipsCount = rs.getInt("notification_sound_tips_count");
                settings.load(playerUUID, currentGroupID, activeGroups, soundNumber, soundEnabled, spyEnabled, messagesEnabled, pluginTipsEnabled, notificationSoundTipsCount);
                allPlayersSettings.add(settings);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return allPlayersSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlayerSettings getPlayerSettings(UUID playerUUID) {
        PlayerSettings playerSettings = null;
        String sql = "SELECT * FROM groupchat_players WHERE player_id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                Long currentGroupID = rs.getLong("current_group_id");
                String[] activeGroupsStr = rs.getString("active_messages_groups").replace("[", "").replace("]", "").split(", ");
                HashSet<Long> activeGroups = new HashSet<Long>();
                for (String groupStr : activeGroupsStr) {
                    activeGroups.add(Long.parseLong(groupStr));
                }
                boolean soundEnabled = Utils.getBooleanFromInt(rs.getInt("sound_enabled"));
                Integer soundNumber = rs.getInt("sound_number");
                boolean spyEnabled = Utils.getBooleanFromInt(rs.getInt("spy_enabled"));
                boolean messagesEnabled = Utils.getBooleanFromInt(rs.getInt("messages_enabled"));
                boolean pluginTipsEnabled = Utils.getBooleanFromInt(rs.getInt("plugin_tips_enabled"));
                Integer notificationSoundTipsCount = rs.getInt("notification_sound_tips_count");
                playerSettings = new PlayerSettings();
                playerSettings.load(playerUUID, currentGroupID, activeGroups, soundNumber, soundEnabled, spyEnabled, messagesEnabled, pluginTipsEnabled, notificationSoundTipsCount);
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return playerSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean playerSettingsExists(UUID playerUUID) {
        boolean playerSettingsExists = false;
        String sql = "SELECT * FROM groupchat_players WHERE player_id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, playerUUID.toString());
            rs = ps.executeQuery();
            playerSettingsExists = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return playerSettingsExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerSettings(PlayerSettings playerSettings) {
        String sql = this.playerSettingsExists(playerSettings.getPlayerUUID()) ? "UPDATE groupchat_players SET current_group_id = ?, active_messages_groups = ?, sound_enabled = ?, sound_number = ?, spy_enabled = ?, messages_enabled = ?, plugin_tips_enabled = ?, notification_sound_tips_count = ? WHERE player_id = ?" : "INSERT INTO groupchat_players (current_group_id, active_messages_groups, sound_enabled, sound_number, spy_enabled, messages_enabled, plugin_tips_enabled, notification_sound_tips_count, player_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, playerSettings.getCurrentGroupID());
            ps.setString(2, playerSettings.getActiveGroups().toString());
            ps.setInt(3, Utils.getIntegerFromBoolean(playerSettings.isMessageNotificationSoundEnabled()));
            ps.setInt(4, playerSettings.getMessageNotificationSoundNumber());
            ps.setInt(5, Utils.getIntegerFromBoolean(playerSettings.isMessageSpyEnabled()));
            ps.setInt(6, Utils.getIntegerFromBoolean(playerSettings.areMessagesEnabled()));
            ps.setInt(7, Utils.getIntegerFromBoolean(playerSettings.arePluginTipsEnabled()));
            ps.setInt(8, playerSettings.getNotificationSoundTipsCount());
            ps.setString(9, playerSettings.getPlayerUUID().toString());
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePlayerSettings(PlayerSettings playerSettings) {
        String sql = "DELETE FROM groupchat_players WHERE player_id = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, playerSettings.getPlayerUUID().toString());
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public List<Message> getMessagesFromHistory(Iterable<Long> ids) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Long id : ids) {
            Message message = this.getMessageFromHistory(id);
            if (message == null) continue;
            messages.add(this.getMessageFromHistory(id));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistoryRelativeToDate(Long timestamp, DateRelationType dateRelationType) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = null;
        switch (dateRelationType) {
            case AFTER: {
                query = "SELECT * FROM groupchat_messages WHERE (sent_date > ?) ORDER BY sent_date DESC";
                break;
            }
            case BEFORE: {
                query = "SELECT * FROM groupchat_messages WHERE (sent_date < ?) ORDER BY sent_date DESC";
                break;
            }
            case SINCE: {
                query = "SELECT * FROM groupchat_messages WHERE (sent_date >= ?) ORDER BY sent_date DESC";
                break;
            }
            case TO: {
                query = "SELECT * FROM groupchat_messages WHERE (sent_date <= ?) ORDER BY sent_date DESC";
            }
        }
        if (query == null) {
            return messages;
        }
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, timestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessagesFromHistoryInDatesRange(Long startTimestamp, Long endTimestamp) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_messages WHERE (sent_date >= ? AND sent_date <= ?) ORDER BY sent_date DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, startTimestamp);
            ps.setLong(2, endTimestamp);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getGroupMessagesFromHistoryRelativeToDate(Long groupID, String playerUUID, Long timestamp, DateRelationType dateRelationType) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = null;
        switch (dateRelationType) {
            case AFTER: {
                if (playerUUID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sent_date > ? ORDER BY sent_date DESC";
                    break;
                }
                if (groupID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE sender_id = ? AND sent_date > ? ORDER BY sent_date DESC";
                    break;
                }
                query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sender_id = ? AND sent_date > ? ORDER BY sent_date DESC";
                break;
            }
            case BEFORE: {
                if (playerUUID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sent_date < ? ORDER BY sent_date DESC";
                    break;
                }
                if (groupID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE sender_id = ? AND sent_date < ? ORDER BY sent_date DESC";
                    break;
                }
                query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sender_id = ? AND sent_date < ? ORDER BY sent_date DESC";
                break;
            }
            case SINCE: {
                if (playerUUID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sent_date >= ? ORDER BY sent_date DESC";
                    break;
                }
                if (groupID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE sender_id = ? AND sent_date >= ? ORDER BY sent_date DESC";
                    break;
                }
                query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sender_id = ? AND sent_date >= ? ORDER BY sent_date DESC";
                break;
            }
            case TO: {
                if (playerUUID == null) {
                    query = "SELECT * FROM groupchat_messages WHERE group_id = ? AND sent_date <= ? ORDER BY sent_date DESC";
                }
                query = groupID == null ? "SELECT * FROM groupchat_messages WHERE sender_id = ? AND sent_date <= ? ORDER BY sent_date DESC" : "SELECT * FROM groupchat_messages WHERE group_id = ? AND sender_id = ? AND sent_date <= ? ORDER BY sent_date DESC";
            }
        }
        if (query == null) {
            return messages;
        }
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            if (groupID == null) {
                ps.setString(1, playerUUID);
                ps.setLong(2, timestamp);
            } else if (playerUUID == null) {
                ps.setLong(1, groupID);
                ps.setLong(2, timestamp);
            } else {
                ps.setLong(1, groupID);
                ps.setString(2, playerUUID);
                ps.setLong(3, timestamp);
            }
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getGroupMessagesFromHistoryInDatesRange(Long groupID, String playerUUID, Long startTimestamp, Long endTimestamp) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = playerUUID == null ? "SELECT * FROM groupchat_messages WHERE group_id = ? AND (sent_date >= ? AND sent_date <= ?) ORDER BY sent_date DESC" : (groupID == null ? "SELECT * FROM groupchat_messages WHERE sender_id = ? AND (sent_date >= ? AND sent_date <= ?) ORDER BY sent_date DESC" : "SELECT * FROM groupchat_messages WHERE (group_id = ? AND sender_id = ?) AND (sent_date >= ? AND sent_date <= ?) ORDER BY sent_date DESC");
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            if (playerUUID == null) {
                ps.setLong(1, groupID);
                ps.setLong(2, startTimestamp);
                ps.setLong(3, endTimestamp);
            } else if (groupID == null) {
                ps.setString(1, playerUUID);
                ps.setLong(2, startTimestamp);
                ps.setLong(3, endTimestamp);
            } else {
                ps.setLong(1, groupID);
                ps.setString(2, playerUUID);
                ps.setLong(3, startTimestamp);
                ps.setLong(4, endTimestamp);
            }
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getGroupMessagesFromHistory(Long groupID, String playerUUID) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = playerUUID == null ? "SELECT * FROM groupchat_messages WHERE group_id = ? ORDER BY sent_date DESC" : (groupID == null ? "SELECT * FROM groupchat_messages WHERE sender_id = ? ORDER BY sent_date DESC" : "SELECT * FROM groupchat_messages WHERE group_id = ? AND sender_id = ? ORDER BY sent_date DESC");
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            if (playerUUID == null) {
                ps.setLong(1, groupID);
            } else if (groupID == null) {
                ps.setString(1, playerUUID);
            } else {
                ps.setLong(1, groupID);
                ps.setString(2, playerUUID);
            }
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getAllMessagesFromHistory() {
        ArrayList<Message> messages = new ArrayList<Message>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_messages ORDER BY sent_date DESC";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Message message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
                    messages.add(message);
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                messages = null;
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessageFromHistory(Long id) {
        Message message = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_messages WHERE id = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                message = new Message(rs.getLong("id"), this.instance.getUtils().getMainUtils().getPlayerUUIDFromString(rs.getString("sender_id")), rs.getLong("group_id"), rs.getLong("sent_date"), rs.getString("message"));
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMessage(Message message) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean update = this.messageExists(message.getId());
        boolean contains_id = message.getId() != -1L;
        try {
            conn = this.ds.getConnection();
            String query = update ? "UPDATE groupchat_messages SET group_id = ?, sender_id = ?, sent_date = ?, message = ? WHERE id = ?" : (contains_id ? "INSERT INTO groupchat_messages (group_id, sender_id, sent_date, message, id) VALUES (?, ?, ?, ?, ?)" : "INSERT INTO groupchat_messages (group_id, sender_id, sent_date, message) VALUES (?, ?, ?, ?)");
            ps = conn.prepareStatement(query, 1);
            ps.setLong(1, message.getGroupID());
            ps.setString(2, message.getSenderUUID().toString());
            ps.setLong(3, message.getDate());
            ps.setString(4, message.getMessageContent());
            if (contains_id) {
                ps.setLong(5, message.getId());
            }
            ps.executeUpdate();
            if (!contains_id) {
                ResultSet keys = ps.getGeneratedKeys();
                if (keys.isBeforeFirst()) {
                    keys.next();
                    long new_id = keys.getLong(1);
                    message.setId(new_id);
                } else {
                    throw new SQLException("Cannot get unique ID for newly created Message object. Check database setup & connection");
                }
            }
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(conn, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean messageExists(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String query = "SELECT * FROM groupchat_messages WHERE id = ?";
        boolean exists = false;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            rs = ps.executeQuery();
            exists = rs.isBeforeFirst();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroupMessages(Long groupID) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM groupchat_messages WHERE group_id = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, groupID);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(Long id) {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM groupchat_messages WHERE id = ?";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessages(List<Message> messages) {
        for (Message message : messages) {
            this.deleteMessage(message.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllMessages() {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = "DELETE FROM groupchat_messages";
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(query);
            ps.executeUpdate();
            this.close(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(conn, ps, null);
            }
            catch (Throwable throwable) {
                this.close(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public void close(Connection conn, PreparedStatement ps, ResultSet res) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (res != null) {
            try {
                res.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closePool() {
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }
}

