/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class BanSubCommand {
    private GroupChat instance;

    public BanSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.ban")) {
                Group currentPlayerGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl);
                if (currentPlayerGroup != null) {
                    if (currentPlayerGroup.getOwner().equals(pl.getUniqueId())) {
                        if (args.length == 2) {
                            String targetPlayerName = args[1];
                            if (!pl.getName().equalsIgnoreCase(targetPlayerName)) {
                                UUID bannedUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(targetPlayerName);
                                if (bannedUUID != null) {
                                    if (!this.instance.getUtils().getGroupUtils().isPlayerBannedInGroup(bannedUUID, currentPlayerGroup)) {
                                        Set<UUID> currentMembers = currentPlayerGroup.getMembers();
                                        currentMembers.remove(bannedUUID);
                                        currentPlayerGroup.setMembers(currentMembers);
                                        Set<UUID> currentBanned = currentPlayerGroup.getBannedPlayers();
                                        currentBanned.add(bannedUUID);
                                        currentPlayerGroup.setBannedPlayers(currentBanned);
                                        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentPlayerGroup);
                                        Player onlineBannedPlayer = Bukkit.getPlayer((UUID)bannedUUID);
                                        if (onlineBannedPlayer != null) {
                                            this.instance.getMessenger().sendMessage((CommandSender)Bukkit.getPlayer((UUID)bannedUUID), this.instance.getMessages().INFO_YOU_NOW_BANNED.replaceAll("<group>", currentPlayerGroup.getName()));
                                        }
                                        HashSet<UUID> excludedRecipients = new HashSet<UUID>(Arrays.asList(pl.getUniqueId()));
                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers(currentPlayerGroup, excludedRecipients, this.instance.getMessages().INFO_PLAYER_NOW_BANNED.replaceAll("<player>", targetPlayerName).replaceAll("<executor>", sender.getName()));
                                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_PLAYER_BANNED_ACTOR.replaceAll("<player>", this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(bannedUUID)).replaceAll("<group>", currentPlayerGroup.getName()));
                                        boolean bannedPlayerChangesMade = false;
                                        boolean groupAutoSwitched = false;
                                        PlayerSettings bannedPlayerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(bannedUUID);
                                        Set<Long> bannedPlayerActiveMessagesGroups = bannedPlayerSettings.getActiveGroups();
                                        if (bannedPlayerActiveMessagesGroups.contains(currentPlayerGroup.getID())) {
                                            bannedPlayerActiveMessagesGroups.remove(currentPlayerGroup.getID());
                                            bannedPlayerSettings.setActiveGroups(bannedPlayerActiveMessagesGroups);
                                            bannedPlayerChangesMade = true;
                                        }
                                        if (bannedPlayerSettings.getCurrentGroupID().equals(currentPlayerGroup.getID())) {
                                            List<Group> otherGroups;
                                            if (this.instance.getSettings().AUTO_SWITCH_GROUP_ON_KICK_AND_BAN && !(otherGroups = this.instance.getUtils().getGroupUtils().getAllPlayerGroups(bannedUUID)).isEmpty()) {
                                                Group newActiveGroup = otherGroups.get(0);
                                                Long newActiveGroupID = newActiveGroup.getID();
                                                bannedPlayerSettings.setCurrentGroupID(newActiveGroupID);
                                                bannedPlayerChangesMade = true;
                                                groupAutoSwitched = true;
                                                if (onlineBannedPlayer != null) {
                                                    this.instance.getMessenger().sendMessage((CommandSender)onlineBannedPlayer, this.instance.getMessages().INFO_YOU_GROUP_SWITCHED.replaceAll("<group>", newActiveGroup.getName()));
                                                    if (this.instance.getSettings().ANNOUNCE_PLAYER_GROUP_SWITCH) {
                                                        HashSet<UUID> excludedRecipientsOnNewGroup = new HashSet<UUID>(Arrays.asList(onlineBannedPlayer.getUniqueId()));
                                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), newActiveGroup, excludedRecipientsOnNewGroup, this.instance.getMessages().INFO_PLAYER_GROUP_SWITCHED.replaceAll("<player>", onlineBannedPlayer.getName()).replaceAll("<group>", newActiveGroup.getName()));
                                                    }
                                                }
                                            }
                                            if (!groupAutoSwitched) {
                                                bannedPlayerSettings.setCurrentGroupID(-1L);
                                            }
                                        }
                                        if (bannedPlayerChangesMade) {
                                            this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(bannedPlayerSettings);
                                        }
                                        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                                    } else {
                                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_IS_BANNED.replaceAll("<player>", args[1]));
                                    }
                                } else {
                                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
                                }
                            } else {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OWNER_CANNOT_LEAVE);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ENTER_PLAYER_NAME);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

