/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.ConsoleSenderTempData;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;

public class ConfirmSubCommand {
    private GroupChat instance;

    public ConfirmSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("groupchat.confirm")) {
            if (args.length < 1) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_CONFIRM);
                return;
            }
            switch (args[0].toUpperCase()) {
                case "DELETE": {
                    this.proceedDeletion(sender);
                    break;
                }
                default: {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_CONFIRM);
                    return;
                }
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }

    private void proceedDeletion(CommandSender sender) {
        List<Message> messages;
        if (!sender.hasPermission("groupchat.deletehistory")) {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            return;
        }
        PlayerTempData tempData = null;
        ConsoleSenderTempData consoleTempData = null;
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            tempData = this.instance.getManagers().getPlayerTempDataManager().getData(pl.getUniqueId());
            messages = tempData.getMessagesAwaitingDeletionConfirmation();
        } else {
            consoleTempData = this.instance.getConsoleSenderTempData();
            messages = consoleTempData.getMessagesAwaitingDeletionConfirmation();
        }
        if (messages == null) {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_DELETE_CONFIRMATION_NO_MESSAGES);
            return;
        }
        this.instance.getStorage().deleteMessages(messages);
        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", String.valueOf(messages.size())));
        if (tempData != null) {
            tempData.setMessagesAwaitingDeletionConfirmation(null);
        }
        if (consoleTempData != null) {
            consoleTempData.setMessagesAwaitingDeletionConfirmation(null);
        }
    }
}

