/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class CreateSubCommand {
    private GroupChat instance;

    public CreateSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.create")) {
                if (args.length > 1) {
                    String groupName = args[1];
                    if (!this.instance.getManagers().getGroupsManager().groupExists(groupName)) {
                        if (this.instance.getManagers().getGroupsManager().getGroupsOwnedByPlayer(pl.getUniqueId()).size() < this.instance.getSettings().MAX_OWNED_GROUPS) {
                            Group group = new Group(pl.getUniqueId(), groupName);
                            Long groupID = this.instance.getManagers().getGroupsManager().getNextGroupID();
                            group.setID(groupID);
                            this.instance.getManagers().getGroupsManager().addGroup(group);
                            this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(group);
                            PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId());
                            playerSettings.setCurrentGroupID(group.getID());
                            Set<Long> activeGroups = playerSettings.getActiveGroups();
                            activeGroups.add(group.getID());
                            playerSettings.setActiveGroups(activeGroups);
                            this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(playerSettings);
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_CREATED.replaceAll("<name>", groupName));
                            this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MAX_OWNED_GROUPS);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_EXISTS);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ENTER_GROUP_NAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

