/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.MessagesRetrievalResult;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;
import pl.maciejnierzwicki.groupchat.utils.StringUtils;

public class DeleteHistorySubCommand {
    private GroupChat instance;

    public DeleteHistorySubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("groupchat.deletehistory")) {
            if (args.length < 2) {
                this.sendHelp(sender);
                return;
            }
            StringBuilder expression = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                expression.append(args[i]);
                if (i + 1 >= args.length) continue;
                expression.append(" ");
            }
            MessagesRetrievalResult result = this.instance.getUtils().getMainUtils().getMessagesMatchingExpression(expression.toString());
            if (result.hasError()) {
                switch (result.getError()) {
                    case INVALID_DATETIME_FORMAT: {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_DATETIME_FORMAT.replaceAll("<format>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
                        break;
                    }
                    case INVALID_EXPRESSION: {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_EXPRESSION);
                        break;
                    }
                    case INVALID_MESSAGE_ID: {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_MESSAGE_ID);
                        break;
                    }
                    case INVALID_GROUP: {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_GROUP);
                    }
                }
                return;
            }
            List<Message> messages = result.getMessages();
            if (messages.isEmpty()) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_DELETE_NO_MESSAGES);
                return;
            }
            if (this.instance.getSettings().MESSAGES_DELETION_BY_COMMAND_REQUIRES_CONFIRMATION) {
                if (sender instanceof Player) {
                    Player pl = (Player)sender;
                    PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManager().getData(pl.getUniqueId());
                    tempData.setMessagesAwaitingDeletionConfirmation(messages);
                } else {
                    this.instance.getConsoleSenderTempData().setMessagesAwaitingDeletionConfirmation(messages);
                }
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_DELETE_CONFIRMATION_REQUIRED.replaceAll("<number>", String.valueOf(messages.size())));
                return;
            }
            this.instance.getStorage().deleteMessages(messages);
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_DELETED.replaceAll("<number>", String.valueOf(messages.size())));
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }

    private void sendHelp(CommandSender sender) {
        for (String line : this.instance.getMessages().HELP_COMMAND_DELETEHISTORY) {
            this.instance.getMessenger().sendMessage(sender, line.replaceAll("<datetimeformat>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
        }
    }
}

