/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class DeleteSubCommand {
    private GroupChat instance;

    public DeleteSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.delete")) {
                Group group = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                if (group != null) {
                    if (group.getOwner().equals(pl.getUniqueId()) || pl.hasPermission("groupchat.delete.unowned")) {
                        this.processDelete((CommandSender)pl, group);
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }

    private void processDelete(CommandSender executor, Group group) {
        group.getMembers().forEach(member -> {
            Set<Long> activeGroups;
            PlayerSettings kickedMemberSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings((UUID)member);
            if (kickedMemberSettings.getCurrentGroupID().equals(group.getID())) {
                List<Group> allKickedPlayerGroups = this.instance.getUtils().getGroupUtils().getAllPlayerGroups((UUID)member);
                boolean group_changed = false;
                for (Group otherGroup : allKickedPlayerGroups) {
                    if (otherGroup.getID().equals(group.getID())) continue;
                    kickedMemberSettings.setCurrentGroupID(otherGroup.getID());
                    group_changed = true;
                    break;
                }
                if (!group_changed) {
                    kickedMemberSettings.setCurrentGroupID(-1L);
                }
                this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(kickedMemberSettings);
            }
            if ((activeGroups = kickedMemberSettings.getActiveGroups()).contains(group.getID())) {
                activeGroups.remove(group.getID());
                kickedMemberSettings.setActiveGroups(activeGroups);
                this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(kickedMemberSettings);
            }
        });
        this.instance.getMessenger().sendMessage(executor, this.instance.getMessages().INFO_GROUP_DELETED);
        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), group, this.instance.getMessages().INFO_GROUP_DELETED_MEMBER.replaceAll("<name>", group.getName()));
        this.instance.getManagers().getGroupsManager().removeGroup(group.getID());
        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
        this.instance.getScheduler().runAsync(() -> this.instance.getStorage().deleteGroup(group.getID()));
    }
}

