/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.MessagesRetrievalResult;
import pl.maciejnierzwicki.groupchat.inventories.MessagesInventory;
import pl.maciejnierzwicki.groupchat.utils.StringUtils;

public class HistorySubCommand {
    private GroupChat instance;

    public HistorySubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("groupchat.history")) {
            if (!this.instance.getSettings().MESSAGES_HISTORY_ENABLED) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_HISTORY_DISABLED);
                return;
            }
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            boolean global_history = false;
            if (pl.isSleeping()) {
                return;
            }
            Group group = null;
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLEASE_WAIT);
            List<Object> messages = new ArrayList();
            if (args.length == 1) {
                group = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl);
                if (group == null) {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    return;
                }
                messages = this.instance.getStorage().getGroupMessagesFromHistory(group.getID());
            } else if (args.length == 2) {
                group = this.instance.getManagers().getGroupsManager().getGroup(args[1]);
                if (group == null) {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_NOT_EXISTS);
                    return;
                }
                if (!group.getMembers().contains(pl.getUniqueId()) && !pl.hasPermission("groupchat.history.others")) {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                    return;
                }
                messages = this.instance.getStorage().getGroupMessagesFromHistory(group.getID());
            } else if (args.length >= 3) {
                if (!args[1].equalsIgnoreCase("-query") && !args[1].equalsIgnoreCase("-q")) {
                    if (args.length > 3) {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_HISTORY);
                        return;
                    }
                    if (args[1].equalsIgnoreCase("*") && args[2].equalsIgnoreCase("*")) {
                        if (!sender.hasPermission("groupchat.history.others")) {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        global_history = true;
                        if (this.instance.getGlobalHistoryInv() == null) {
                            messages = this.instance.getStorage().getAllMessagesFromHistory();
                        }
                    } else if (args[2].equalsIgnoreCase("*")) {
                        group = this.instance.getManagers().getGroupsManager().getGroup(args[1]);
                        if (group == null) {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_NOT_EXISTS);
                            return;
                        }
                        if (!group.getMembers().contains(pl.getUniqueId()) && !sender.hasPermission("groupchat.history.others")) {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        messages = this.instance.getStorage().getGroupMessagesFromHistory(group.getID());
                    } else if (args[1].equalsIgnoreCase("*")) {
                        if (!args[2].equalsIgnoreCase(sender.getName()) && !sender.hasPermission("groupchat.history.others")) {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                            return;
                        }
                        UUID senderUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(args[2]);
                        if (senderUUID == null) {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
                            return;
                        }
                    }
                } else {
                    if (!sender.hasPermission("groupchat.history.queries")) {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
                        return;
                    }
                    StringBuilder expression = new StringBuilder();
                    for (int i = 2; i < args.length; ++i) {
                        expression.append(args[i]);
                        if (i + 1 >= args.length) continue;
                        expression.append(" ");
                    }
                    MessagesRetrievalResult result = this.instance.getUtils().getMainUtils().getMessagesMatchingExpression(expression.toString());
                    if (result.hasError()) {
                        switch (result.getError()) {
                            case INVALID_DATETIME_FORMAT: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_DATETIME_FORMAT.replaceAll("<format>", StringUtils.getStringFromList(this.instance.getSettings().IN_COMMAND_DATETIME_FORMAT_PLAIN)));
                                break;
                            }
                            case INVALID_EXPRESSION: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_EXPRESSION);
                                break;
                            }
                            case INVALID_MESSAGE_ID: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_MESSAGE_ID);
                                break;
                            }
                            case INVALID_GROUP: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_GROUP);
                                break;
                            }
                            case INVALID_PLAYER: {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_MESSAGES_QUERY_INVALID_PLAYER);
                            }
                        }
                        return;
                    }
                    messages = result.getMessages();
                    if (result.containsAllStoredMessages()) {
                        global_history = true;
                    }
                }
            }
            MessagesInventory inv = null;
            boolean from_cache = false;
            if (global_history && this.instance.getGlobalHistoryInv() != null) {
                from_cache = true;
                inv = this.instance.getGlobalHistoryInv();
            } else {
                if (messages.isEmpty()) {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_MESSAGES);
                    return;
                }
                inv = new MessagesInventory(this.instance, messages, pl);
                inv.load();
                inv.addExtraPageItems();
            }
            if (global_history && !from_cache) {
                this.instance.setGlobalHistoryInv(inv);
                this.instance.setLastGlobalHistoryInvGen(System.currentTimeMillis());
            }
            MessagesInventory f_inv = inv;
            this.instance.getManagers().getPlayerTempDataManager().getData(pl.getUniqueId()).setLastMessagesInventory(inv);
            this.instance.getScheduler().runSync(() -> {
                this.instance.getPlayerStates().setState(pl, PlayerStates.State.WAITING_MESSAGES_HISTORY);
                pl.openInventory(f_inv.get(1));
            });
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }
}

