/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.GroupType;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class JoinSubCommand {
    private GroupChat instance;

    public JoinSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.join")) {
                if (args.length == 2) {
                    String groupName = args[1];
                    Group group = this.instance.getManagers().getGroupsManager().getGroup(groupName);
                    if (group != null) {
                        boolean privateGroup = false;
                        if (group.getType() == GroupType.PRIVATE) {
                            privateGroup = true;
                            Long lastInvitationGroupID = this.instance.getManagers().getInvitationsManager().getGroupInvitation(pl);
                            if (!(lastInvitationGroupID != null && lastInvitationGroupID.equals(group.getID()) || sender.hasPermission("groupchat.join.private"))) {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_PRIVATE_NEED_INVITATION);
                                return;
                            }
                        }
                        if (!this.instance.getUtils().getGroupUtils().isPlayerMemberInGroup(pl, group)) {
                            if (!this.instance.getUtils().getGroupUtils().isPlayerBannedInGroup(pl, group)) {
                                if (privateGroup) {
                                    this.instance.getManagers().getInvitationsManager().deleteLastInvitation(pl);
                                }
                                this.processJoin(pl, group);
                            } else {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_BANNED);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_MEMBER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_NOT_EXISTS);
                    }
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }

    private void processJoin(Player pl, Group group) {
        Set<UUID> currentMembers = group.getMembers();
        currentMembers.add(pl.getUniqueId());
        group.setMembers(currentMembers);
        PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId());
        playerSettings.setCurrentGroupID(group.getID());
        Set<Long> activeGroups = playerSettings.getActiveGroups();
        activeGroups.add(group.getID());
        playerSettings.setActiveGroups(activeGroups);
        this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(playerSettings);
        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(group);
        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), group, new HashSet<UUID>(Arrays.asList(pl.getUniqueId())), this.instance.getMessages().INFO_PLAYER_JOINED.replaceAll("<player>", pl.getName()));
        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_YOU_JOINED.replaceAll("<group>", group.getName()));
        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
    }
}

