/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.utils.MainUtils;

public class KickSubCommand {
    private GroupChat instance;

    public KickSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.kick")) {
                if (args.length == 2) {
                    if (this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId()) != null) {
                        Group currentPlayerGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                        if (currentPlayerGroup.getOwner().equals(pl.getUniqueId())) {
                            if (!pl.getName().equalsIgnoreCase(args[1])) {
                                UUID kickedUUID = MainUtils.getPlayerId(args[1]);
                                if (kickedUUID != null) {
                                    if (this.instance.getUtils().getGroupUtils().isPlayerMemberInGroup(kickedUUID, currentPlayerGroup)) {
                                        Set<UUID> currentMembers = currentPlayerGroup.getMembers();
                                        currentMembers.remove(kickedUUID);
                                        currentPlayerGroup.setMembers(currentMembers);
                                        Player onlineKickedPlayer = Bukkit.getPlayer((UUID)kickedUUID);
                                        if (onlineKickedPlayer != null) {
                                            this.instance.getMessenger().sendMessage((CommandSender)onlineKickedPlayer, this.instance.getMessages().INFO_YOU_KICKED.replaceAll("<group>", currentPlayerGroup.getName()));
                                        }
                                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_PLAYER_KICKED_ACTOR.replaceAll("<player>", this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(kickedUUID)).replaceAll("<group>", currentPlayerGroup.getName()));
                                        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentPlayerGroup);
                                        boolean kickedPlayerChangesMade = false;
                                        boolean groupAutoSwitched = false;
                                        PlayerSettings kickedPlayerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(kickedUUID);
                                        Set<Long> activeGroups = kickedPlayerSettings.getActiveGroups();
                                        if (activeGroups.contains(currentPlayerGroup.getID())) {
                                            activeGroups.remove(currentPlayerGroup.getID());
                                            kickedPlayerSettings.setActiveGroups(activeGroups);
                                            kickedPlayerChangesMade = true;
                                        }
                                        if (kickedPlayerSettings.getCurrentGroupID().equals(currentPlayerGroup.getID())) {
                                            List<Group> otherGroups;
                                            if (this.instance.getSettings().AUTO_SWITCH_GROUP_ON_KICK_AND_BAN && !(otherGroups = this.instance.getUtils().getGroupUtils().getAllPlayerGroups(kickedUUID)).isEmpty()) {
                                                Group newActiveGroup = otherGroups.get(0);
                                                Long newActiveGroupID = newActiveGroup.getID();
                                                kickedPlayerSettings.setCurrentGroupID(newActiveGroupID);
                                                groupAutoSwitched = true;
                                                kickedPlayerChangesMade = true;
                                                if (onlineKickedPlayer != null) {
                                                    this.instance.getMessenger().sendMessage((CommandSender)onlineKickedPlayer, this.instance.getMessages().INFO_YOU_GROUP_SWITCHED.replaceAll("<group>", newActiveGroup.getName()));
                                                    if (this.instance.getSettings().ANNOUNCE_PLAYER_GROUP_SWITCH) {
                                                        HashSet<UUID> excludedRecipientsOnNewGroup = new HashSet<UUID>(Arrays.asList(onlineKickedPlayer.getUniqueId()));
                                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), newActiveGroup, excludedRecipientsOnNewGroup, this.instance.getMessages().INFO_PLAYER_GROUP_SWITCHED.replaceAll("<player>", onlineKickedPlayer.getName()).replaceAll("<group>", newActiveGroup.getName()));
                                                    }
                                                }
                                            }
                                            if (!groupAutoSwitched) {
                                                kickedPlayerSettings.setCurrentGroupID(-1L);
                                            }
                                        }
                                        if (kickedPlayerChangesMade) {
                                            this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(kickedPlayerSettings);
                                        }
                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers(currentPlayerGroup, this.instance.getMessages().INFO_PLAYER_KICKED.replaceAll("<player>", args[1]));
                                        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                                    } else {
                                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_IN_GROUP);
                                    }
                                } else {
                                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
                                }
                            } else {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OWNER_CANNOT_LEAVE);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ENTER_PLAYER_NAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

