/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class LeaveSubCommand {
    private GroupChat instance;

    public LeaveSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player leavingPlayer = (Player)sender;
            if (leavingPlayer.hasPermission("groupchat.leave")) {
                if (this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(leavingPlayer.getUniqueId()) != null) {
                    Group currentPlayerGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(leavingPlayer.getUniqueId());
                    if (!currentPlayerGroup.getOwner().equals(leavingPlayer.getUniqueId())) {
                        Set<UUID> currentMembers = currentPlayerGroup.getMembers();
                        currentMembers.remove(leavingPlayer.getUniqueId());
                        currentPlayerGroup.setMembers(currentMembers);
                        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentPlayerGroup);
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_LEFT_GROUP.replaceAll("<group>", currentPlayerGroup.getName()));
                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), currentPlayerGroup, this.instance.getMessages().INFO_PLAYER_LEFT_GROUP.replaceAll("<player>", leavingPlayer.getName()));
                        boolean leavingPlayerChangesMade = false;
                        boolean groupAutoSwitched = false;
                        PlayerSettings leavingPlayerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(leavingPlayer.getUniqueId());
                        Set<Long> activeGroups = leavingPlayerSettings.getActiveGroups();
                        if (activeGroups.contains(currentPlayerGroup.getID())) {
                            activeGroups.remove(currentPlayerGroup.getID());
                            leavingPlayerSettings.setActiveGroups(activeGroups);
                            leavingPlayerChangesMade = true;
                        }
                        if (leavingPlayerSettings.getCurrentGroupID().equals(currentPlayerGroup.getID())) {
                            List<Group> otherGroups;
                            if (this.instance.getSettings().AUTO_SWITCH_GROUP_ON_LEAVE && !(otherGroups = this.instance.getUtils().getGroupUtils().getAllPlayerGroups(leavingPlayer.getUniqueId())).isEmpty()) {
                                Group newActiveGroup = otherGroups.get(0);
                                Long newActiveGroupID = newActiveGroup.getID();
                                leavingPlayerSettings.setCurrentGroupID(newActiveGroupID);
                                groupAutoSwitched = true;
                                leavingPlayerChangesMade = true;
                                this.instance.getMessenger().sendMessage((CommandSender)leavingPlayer, this.instance.getMessages().INFO_YOU_GROUP_SWITCHED.replaceAll("<group>", newActiveGroup.getName()));
                                if (this.instance.getSettings().ANNOUNCE_PLAYER_GROUP_SWITCH) {
                                    HashSet<UUID> excludedRecipientsOnNewGroup = new HashSet<UUID>(Arrays.asList(leavingPlayer.getUniqueId()));
                                    this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), newActiveGroup, excludedRecipientsOnNewGroup, this.instance.getMessages().INFO_PLAYER_GROUP_SWITCHED.replaceAll("<player>", leavingPlayer.getName()).replaceAll("<group>", newActiveGroup.getName()));
                                }
                            }
                            if (!groupAutoSwitched) {
                                leavingPlayerSettings.setCurrentGroupID(-1L);
                            }
                        }
                        if (leavingPlayerChangesMade) {
                            this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(leavingPlayerSettings);
                        }
                        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OWNER_CANNOT_LEAVE);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

