/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.List;
import org.bukkit.command.CommandSender;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.utils.Utils;

public class ListSubCommand {
    private GroupChat instance;

    public ListSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender.hasPermission("groupchat.list")) {
            List<List<String>> groups = this.instance.getManagers().getGroupsManager().getAllGroupsChatList();
            int number = 1;
            if (args.length > 1) {
                if (Utils.isInteger(args[1])) {
                    number = Integer.valueOf(args[1]);
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_TYPE_NUMBER);
                    return;
                }
            }
            if (groups.size() > 0) {
                if (groups.size() >= number) {
                    for (String headerLine : this.instance.getMessages().INFO_ALLGROUPS_HEADER) {
                        this.instance.getMessenger().sendMessageWithCustomPrefix(sender, headerLine.replaceAll("<page>", String.valueOf(number)).replaceAll("<lastpage>", String.valueOf(groups.size())), "");
                    }
                    for (String line : groups.get(number - 1)) {
                        this.instance.getMessenger().sendMessageWithCustomPrefix(sender, line, "");
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PAGE);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_GROUPS);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }
}

