/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;

public class SetDescriptionSubCommand {
    private GroupChat instance;

    public SetDescriptionSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.setdescription")) {
                if (args.length >= 2) {
                    Group currentGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (currentGroup != null) {
                        if (currentGroup.getOwner().equals(pl.getUniqueId())) {
                            String newDescription = args[1].replaceAll(this.instance.getSettings().SPACE_CODE_IN_COMMANDS, " ");
                            if (newDescription.trim().length() > this.instance.getSettings().GROUP_DESCRIPTION_MAXLENGTH) {
                                this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_VALUE_TOO_LONG.replaceAll("<max>", String.valueOf(this.instance.getSettings().GROUP_DESCRIPTION_MAXLENGTH)));
                                return;
                            }
                            currentGroup.setDescription(newDescription);
                            this.instance.getUtils().getGroupUtils().messageAllGroupMembers(currentGroup, this.instance.getMessages().INFO_DESCRIPTION_SET.replaceAll("<description>", newDescription));
                            this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentGroup);
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_SETDESCRIPTION);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

