/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;

public class SetDisplayNameSubCommand {
    private GroupChat instance;

    public SetDisplayNameSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.setdisplayname")) {
                if (args.length >= 2) {
                    Group currentGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (currentGroup != null) {
                        if (currentGroup.getOwner().equals(pl.getUniqueId())) {
                            String newDisplayName = args[1].replaceAll(this.instance.getSettings().SPACE_CODE_IN_COMMANDS, " ");
                            if (newDisplayName.trim().length() > this.instance.getSettings().GROUP_DISPLAYNAME_MAXLENGTH) {
                                this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_VALUE_TOO_LONG.replaceAll("<max>", String.valueOf(this.instance.getSettings().GROUP_DISPLAYNAME_MAXLENGTH)));
                                return;
                            }
                            currentGroup.setDisplayName(newDisplayName);
                            this.instance.getUtils().getGroupUtils().messageAllGroupMembers(currentGroup, this.instance.getMessages().INFO_DISPLAYNAME_SET.replaceAll("<displayname>", newDisplayName));
                            this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentGroup);
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_SETDISPLAYNAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

