/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;

public class SetNameSubCommand {
    private GroupChat instance;

    public SetNameSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.setname")) {
                if (args.length >= 2) {
                    Group currentGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (currentGroup != null) {
                        if (currentGroup.getOwner().equals(pl.getUniqueId())) {
                            String newName = args[1];
                            if (this.instance.getManagers().getGroupsManager().getGroup(newName) != null) {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_EXISTS);
                                return;
                            }
                            if (newName.trim().length() > this.instance.getSettings().GROUP_SHORTNAME_MAXLENGTH) {
                                this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_VALUE_TOO_LONG.replaceAll("<max>", String.valueOf(this.instance.getSettings().GROUP_SHORTNAME_MAXLENGTH)));
                                return;
                            }
                            currentGroup.setName(newName);
                            this.instance.getUtils().getGroupUtils().messageAllGroupMembers(currentGroup, this.instance.getMessages().INFO_NAME_SET.replaceAll("<name>", newName));
                            this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(currentGroup);
                            this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().HELP_COMMAND_SETNAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

