/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.utils.MainUtils;

public class SetOwnerSubCommand {
    private GroupChat instance;

    public SetOwnerSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.setowner")) {
                if (args.length == 2) {
                    if (this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId()) != null) {
                        Group group = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                        if (group.getOwner().equals(pl.getUniqueId())) {
                            String newOwnerName = args[1];
                            UUID newOwnerUUID = MainUtils.getPlayerId(newOwnerName);
                            if (newOwnerUUID != null) {
                                if (this.instance.getUtils().getGroupUtils().isPlayerMemberInGroup(newOwnerUUID, group)) {
                                    if (!newOwnerUUID.equals(group.getOwner())) {
                                        group.setOwner(newOwnerUUID);
                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers(group, this.instance.getMessages().INFO_OWNER_SET.replaceAll("<player>", newOwnerName));
                                        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(group);
                                    } else {
                                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_ALREADY_OWNER);
                                    }
                                } else {
                                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_IN_GROUP);
                                }
                            } else {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ENTER_PLAYER_NAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

