/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class ShowSubCommand {
    private GroupChat instance;

    public ShowSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.show")) {
                if (args.length == 2) {
                    Group selectedGroup = this.instance.getManagers().getGroupsManager().getGroup(args[1]);
                    if (selectedGroup == null) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_GROUP_NOT_EXISTS);
                        return;
                    }
                    List<Group> activeMessagesGroups = this.instance.getUtils().getGroupUtils().getPlayerActiveMessagesGroups(pl.getUniqueId());
                    if (activeMessagesGroups.contains(selectedGroup)) {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_GROUP_ALREADY_SHOWN.replaceAll("<group>", selectedGroup.getName()));
                        return;
                    }
                    List<Group> playerGroups = this.instance.getUtils().getGroupUtils().getAllPlayerGroups(pl.getUniqueId());
                    boolean isMember = false;
                    for (Group group : playerGroups) {
                        if (!group.getID().equals(selectedGroup.getID())) continue;
                        isMember = true;
                        break;
                    }
                    if (!isMember) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_YOU_NOT_MEMBER);
                        return;
                    }
                    PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId());
                    Set<Long> activeGroups = playerSettings.getActiveGroups();
                    activeGroups.add(selectedGroup.getID());
                    playerSettings.setActiveGroups(activeGroups);
                    this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(playerSettings);
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_GROUP_SHOW_ON.replaceAll("<group>", selectedGroup.getName()));
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_TYPE_SHORTNAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

