/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.PlayerStates;
import pl.maciejnierzwicki.groupchat.data.InventoryLoadResult;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;
import pl.maciejnierzwicki.groupchat.inventories.SoundInventory;

public class SoundSubCommand {
    private GroupChat instance;

    public SoundSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender) {
        if (sender.hasPermission("groupchat.sound")) {
            if (!(sender instanceof Player)) {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
                return;
            }
            Player pl = (Player)sender;
            PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManager().getData(pl.getUniqueId());
            SoundInventory soundInv = tempData.getLastSoundInventory();
            if (soundInv == null) {
                SoundInventory loadedSoundInv = new SoundInventory(this.instance, pl);
                this.instance.getScheduler().runAsync(() -> {
                    if (loadedSoundInv.load() != InventoryLoadResult.SUCCESS) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_ERROR);
                        return;
                    }
                    tempData.setLastSoundInventory(loadedSoundInv);
                    this.sendSoundInvOnNextTick(pl, loadedSoundInv);
                });
            } else {
                this.sendSoundInvOnNextTick(pl, soundInv);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
        }
    }

    private void sendSoundInvOnNextTick(Player pl, SoundInventory soundInventory) {
        this.instance.getScheduler().runSync(() -> {
            this.instance.getPlayerStates().setState(pl, PlayerStates.State.WAITING_SOUND_INVENTORY);
            pl.openInventory(soundInventory.get(1));
        });
    }
}

