/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;

public class SwitchSubCommand {
    private GroupChat instance;

    public SwitchSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.switch")) {
                if (args.length == 2) {
                    Group selectedGroup = this.instance.getManagers().getGroupsManager().getGroup(args[1]);
                    if (selectedGroup == null) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_GROUP_NOT_EXISTS);
                        return;
                    }
                    if (!this.instance.getUtils().getGroupUtils().isPlayerMemberInGroup(pl, selectedGroup)) {
                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_YOU_NOT_MEMBER_SELECTED_GROUP);
                        return;
                    }
                    Group currentGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (currentGroup.getID().equals(selectedGroup.getID())) {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ALREADY_CURRENT_GROUP);
                        return;
                    }
                    PlayerSettings playerSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(pl.getUniqueId());
                    playerSettings.setCurrentGroupID(selectedGroup.getID());
                    this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(playerSettings);
                    this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_YOU_GROUP_SWITCHED.replaceAll("<group>", selectedGroup.getName()));
                    if (this.instance.getSettings().ANNOUNCE_PLAYER_GROUP_SWITCH) {
                        HashSet<UUID> excludedRecipients = new HashSet<UUID>(Arrays.asList(pl.getUniqueId()));
                        if (currentGroup != null) {
                            this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), currentGroup, excludedRecipients, this.instance.getMessages().INFO_PLAYER_GROUP_SWITCHED.replaceAll("<player>", pl.getName()).replaceAll("<group>", selectedGroup.getName()));
                        }
                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers((CommandSender)Bukkit.getConsoleSender(), selectedGroup, excludedRecipients, this.instance.getMessages().INFO_PLAYER_GROUP_SWITCHED.replaceAll("<player>", pl.getName()).replaceAll("<group>", selectedGroup.getName()));
                    }
                    this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_TYPE_SHORTNAME);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

