/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.subcommands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.utils.MainUtils;

public class UnBanSubCommand {
    private GroupChat instance;

    public UnBanSubCommand(GroupChat plugin) {
        this.instance = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player pl = (Player)sender;
            if (pl.hasPermission("groupchat.unban")) {
                if (this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId()) != null) {
                    Group group = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(pl.getUniqueId());
                    if (group.getOwner().equals(pl.getUniqueId())) {
                        if (args.length == 2) {
                            if (!pl.getName().equalsIgnoreCase(args[1])) {
                                UUID unbannedUUID = MainUtils.getPlayerId(args[1]);
                                if (unbannedUUID != null) {
                                    if (this.instance.getUtils().getGroupUtils().isPlayerBannedInGroup(unbannedUUID, group)) {
                                        Set<UUID> bannedPlayers = group.getBannedPlayers();
                                        bannedPlayers.remove(unbannedUUID);
                                        group.setBannedPlayers(bannedPlayers);
                                        Player unbannedPlayer = Bukkit.getPlayer((UUID)unbannedUUID);
                                        if (unbannedPlayer != null) {
                                            this.instance.getMessenger().sendMessage((CommandSender)Bukkit.getPlayer((UUID)unbannedUUID), this.instance.getMessages().INFO_YOU_NOW_UNBANNED.replaceAll("<group>", group.getName()));
                                        }
                                        HashSet<UUID> excludedRecipients = new HashSet<UUID>(Arrays.asList(pl.getUniqueId()));
                                        this.instance.getUtils().getGroupUtils().messageAllGroupMembers(group, excludedRecipients, this.instance.getMessages().INFO_PLAYER_NOW_UNBANNED.replaceAll("<player>", args[1]).replaceAll("<executor>", sender.getName()));
                                        this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_PLAYER_UNBANNED_ACTOR.replaceAll("<player>", this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(unbannedUUID)).replaceAll("<group>", group.getName()));
                                        this.instance.getUtils().getMainUtils().sendGroupModifyEventOnNextTick(group);
                                        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
                                    } else {
                                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_BANNED.replaceAll("<player>", args[1]));
                                    }
                                } else {
                                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_PLAYER_NOT_FOUND);
                                }
                            } else {
                                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_OWNER_CANNOT_LEAVE);
                            }
                        } else {
                            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_ENTER_PLAYER_NAME);
                        }
                    } else {
                        this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_OWNER);
                    }
                } else {
                    this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_ACTIVE_GROUP);
                }
            } else {
                this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_NO_PERMISSION);
            }
        } else {
            this.instance.getMessenger().sendMessage(sender, this.instance.getMessages().INFO_YOU_NOT_PLAYER);
        }
    }
}

