/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.tabcompleters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.utils.Utils;

public class HistorySubCommandTabCompleter {
    private GroupChat instance;

    public HistorySubCommandTabCompleter(GroupChat plugin) {
        this.instance = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        List<String> complete = new ArrayList<String>();
        if (!sender.hasPermission("groupchat.history")) {
            return complete;
        }
        if (args.length == 2) {
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_GROUP_SHORTNAME);
            }
            if (sender.hasPermission("groupchat.history.others")) {
                complete.add("*");
                complete.add("-query");
            }
        } else if (args.length == 3) {
            complete = this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, args[2]);
            if (complete.size() == 0) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAME);
            }
            if (sender.hasPermission("groupchat.history.others")) {
                if (!args[1].equalsIgnoreCase("-query") && !args[1].equalsIgnoreCase("-q")) {
                    complete.add("*");
                } else {
                    complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_PLAYER_NAMES_PAIR);
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_ID);
                    complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_MESSAGE_IDS_GROUP);
                }
            }
        } else if (args.length == 4 && sender.hasPermission("groupchat.history.others")) {
            if (args[2].equalsIgnoreCase("before") || args[2].equalsIgnoreCase("after") || args[2].equalsIgnoreCase("since") || args[2].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[2].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (!Utils.isInteger(args[2]) && !args[2].equalsIgnoreCase("ALL")) {
                complete.addAll(Arrays.asList("ALL", "AFTER", "BEFORE", "SINCE", "TO", "RANGE"));
            }
        } else if (args.length == 5 && sender.hasPermission("groupchat.history.others")) {
            if (args[3].equalsIgnoreCase("before") || args[3].equalsIgnoreCase("after") || args[3].equalsIgnoreCase("since") || args[3].equalsIgnoreCase("to")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_DATETIME);
            } else if (args[3].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_START_DATETIME);
            } else if (args[3].equalsIgnoreCase("range")) {
                complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
            }
        } else if (args.length == 6 && sender.hasPermission("groupchat.history.others") && args[3].equalsIgnoreCase("range")) {
            complete.add(this.instance.getMessages().TABCOMPLETE_EMPTY_END_DATETIME);
        }
        return complete;
    }
}

