/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.tabcompleters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;

public class InviteSubCommandTabCompleter {
    private GroupChat instance;

    public InviteSubCommandTabCompleter(GroupChat plugin) {
        this.instance = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> complete = new ArrayList<String>();
        if (!sender.hasPermission("groupchat.invite") || !(sender instanceof Player)) {
            return complete;
        }
        String secondArg = args[1].toLowerCase();
        Player player = (Player)sender;
        Group currentGroup = this.instance.getUtils().getGroupUtils().getPlayerCurrentGroup(player);
        if (currentGroup == null) {
            return complete;
        }
        ArrayList<String> memberNames = new ArrayList<String>();
        for (UUID memberUUID : currentGroup.getMembers()) {
            String memberPlayerName = this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(memberUUID);
            if (memberPlayerName == null) continue;
            memberNames.add(memberPlayerName);
        }
        List<String> possibleCompletions = this.instance.getUtils().getMainUtils().getApplicablePlayerCompletions(sender, secondArg);
        for (String playerName : possibleCompletions) {
            if (memberNames.contains(playerName) || secondArg.length() != 0 && !playerName.toLowerCase().startsWith(secondArg)) continue;
            complete.add(playerName);
        }
        Collections.sort(complete, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
        return complete;
    }
}

