/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.GroupType;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;
import pl.maciejnierzwicki.groupchat.sound.SoundConfiguration;

public class GroupUtils {
    private GroupChat instance;
    private Set<UUID> playerSoundConfigurationWarningsSent;

    public GroupUtils(GroupChat plugin) {
        this.instance = plugin;
        this.playerSoundConfigurationWarningsSent = new HashSet<UUID>();
    }

    private boolean wasPlayerSoundConfigurationWarningSent(UUID playerUUID) {
        return this.playerSoundConfigurationWarningsSent.contains(playerUUID);
    }

    private void setPlayerSoundConfigurationWarningSent(UUID playerUUID) {
        this.playerSoundConfigurationWarningsSent.add(playerUUID);
    }

    public String getGroupTypeFormatted(GroupType groupType) {
        switch (groupType) {
            case PUBLIC: {
                return this.instance.getMessages().GROUP_TYPE_PUBLIC;
            }
            case PRIVATE: {
                return this.instance.getMessages().GROUP_TYPE_PRIVATE;
            }
        }
        return this.instance.getMessages().INFO_ERROR;
    }

    public void messageAllGroupMembers(CommandSender sender, Group group, Set<UUID> excludedMembers, String message) {
        boolean each_sound_requires_permission = this.instance.getSettings().EACH_NOTIFICATION_SOUND_REQUIRES_PERMISSION;
        for (UUID groupMember : group.getMembers()) {
            if (excludedMembers.contains(groupMember) || !this.getPlayerActiveMessagesGroups(groupMember).contains(group) || Bukkit.getPlayer((UUID)groupMember) == null) continue;
            Player pl = Bukkit.getPlayer((UUID)groupMember);
            UUID recipientUUID = pl.getUniqueId();
            PlayerSettings recipientSettings = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(recipientUUID);
            if (!recipientSettings.areMessagesEnabled()) continue;
            this.instance.getMessenger().sendMessageWithCustomPrefix((CommandSender)pl, message, this.instance.getMessages().GROUP_PREFIX.replaceAll("<group>", group.getName()));
            SoundConfiguration soundConfiguration = this.instance.getManagers().getSoundConfigurationsManager().getConfiguration(recipientSettings.getMessageNotificationSoundNumber());
            if (recipientSettings.isMessageNotificationSoundEnabled() && soundConfiguration == null) {
                if (this.wasPlayerSoundConfigurationWarningSent(recipientUUID)) continue;
                this.instance.getLogger().warning("Player " + pl.getName() + " is using unknown message notification sound with ID " + recipientSettings.getMessageNotificationSoundNumber());
                this.setPlayerSoundConfigurationWarningSent(recipientUUID);
                continue;
            }
            boolean send_sound = true;
            if (sender != null) {
                boolean bl = send_sound = pl != sender && recipientSettings.isMessageNotificationSoundEnabled() && (!each_sound_requires_permission || pl.hasPermission("groupchat.sound"));
            }
            if (!send_sound) continue;
            this.instance.getSoundPlayer().play(pl, soundConfiguration);
            if (!this.instance.getSettings().PLUGIN_TIPS || !recipientSettings.arePluginTipsEnabled()) continue;
            if (this.instance.getSettings().PLUGIN_TIPS_MODE == 1) {
                PlayerTempData recipientTempData = this.instance.getManagers().getPlayerTempDataManager().getData(pl.getUniqueId());
                if (recipientTempData.hasReceivedSoundTip()) continue;
                this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_SOUND_CHANGE_TIP);
                recipientTempData.setReceivedSoundTip(true);
                continue;
            }
            int recipientSoundTipsCount = recipientSettings.getNotificationSoundTipsCount();
            if (recipientSoundTipsCount >= 1) continue;
            this.instance.getMessenger().sendMessage((CommandSender)pl, this.instance.getMessages().INFO_SOUND_CHANGE_TIP);
            recipientSettings.setNotificationSoundTipsCount(recipientSoundTipsCount + 1);
            this.instance.getUtils().getMainUtils().sendPlayerSettingsModifyEventOnNextTick(recipientSettings);
        }
    }

    public void messageAllGroupMembers(CommandSender sender, Group group, String message) {
        this.messageAllGroupMembers(sender, group, new HashSet<UUID>(), message);
    }

    public void messageAllGroupMembers(Group group, Set<UUID> excludedMembers, String message) {
        this.messageAllGroupMembers(null, group, excludedMembers, message);
    }

    public void messageAllGroupMembers(Group group, String message) {
        this.messageAllGroupMembers(null, group, new HashSet<UUID>(), message);
    }

    public List<Group> getAllPlayerGroups(UUID playerID) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.instance.getManagers().getGroupsManager().getAllGroups()) {
            if (!this.isPlayerMemberInGroup(playerID, group)) continue;
            groups.add(group);
        }
        return groups;
    }

    public List<Group> getAllPlayerGroups(Player player) {
        return this.getAllPlayerGroups(player.getUniqueId());
    }

    public Group getPlayerCurrentGroup(UUID playerUUID) {
        Long currentGroupID = this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(playerUUID).getCurrentGroupID();
        return this.instance.getManagers().getGroupsManager().getGroup(currentGroupID);
    }

    public Group getPlayerCurrentGroup(Player player) {
        return this.getPlayerCurrentGroup(player.getUniqueId());
    }

    public boolean isPlayerBannedInGroup(UUID uuid, Group group) {
        return group.getBannedPlayers().contains(uuid);
    }

    public boolean isPlayerBannedInGroup(Player player, Group group) {
        return this.isPlayerBannedInGroup(player.getUniqueId(), group);
    }

    public boolean isPlayerMemberInGroup(UUID uuid, Group group) {
        return group.getMembers().contains(uuid);
    }

    public boolean isPlayerMemberInGroup(Player player, Group group) {
        return this.isPlayerMemberInGroup(player.getUniqueId(), group);
    }

    public boolean isPlayerMemberInGroup(UUID uuid, Long groupID) {
        Group group = this.instance.getManagers().getGroupsManager().getGroup(groupID);
        return group != null && group.getMembers().contains(uuid);
    }

    public boolean isPlayerMemberInGroup(Player player, Long groupID) {
        return this.isPlayerMemberInGroup(player.getUniqueId(), groupID);
    }

    public boolean isPlayerOwnerInGroup(UUID uuid, Group group) {
        return group.getOwner().equals(uuid);
    }

    public boolean isPlayerOwnerInGroup(Player player, Group group) {
        return this.isPlayerOwnerInGroup(player.getUniqueId(), group);
    }

    public List<Group> getPlayerActiveMessagesGroups(UUID playerUUID) {
        ArrayList<Group> playerActiveMessagesGroups = new ArrayList<Group>();
        for (Long groupID : this.instance.getManagers().getPlayerSettingsManager().getPlayerSettings(playerUUID).getActiveGroups()) {
            playerActiveMessagesGroups.add(this.instance.getManagers().getGroupsManager().getGroup(groupID));
        }
        return playerActiveMessagesGroups;
    }

    public List<String> getGroupMemberNames(Group group) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (UUID memberUUID : group.getMembers()) {
            String name = this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(memberUUID);
            if (name == null) continue;
            memberNames.add(name);
        }
        return memberNames;
    }

    public void sendGroupInfo(CommandSender sender, Group group) {
        String whiteColor;
        List<String> members = this.getGroupMemberNames(group);
        StringBuilder membersList = new StringBuilder();
        Iterator<String> it = members.iterator();
        String greenColor = this.instance.getSettings().MODERN_CHAT_FORMATTING ? "<green>" : "&a";
        String string = whiteColor = this.instance.getSettings().MODERN_CHAT_FORMATTING ? "<white>" : "&f";
        while (it.hasNext()) {
            String member = it.next();
            membersList.append(greenColor + member);
            if (!it.hasNext()) continue;
            membersList.append(whiteColor + ", ");
        }
        List<String> infoMessage = this.instance.getMessages().INFO_GROUP_INFO;
        for (String line : infoMessage) {
            line = line.replaceAll("<shortname>", group.getName()).replaceAll("<displayname>", group.getDisplayName()).replaceAll("<memberscount>", String.valueOf(group.getMembers().size())).replaceAll("<type>", this.getGroupTypeFormatted(group.getType())).replaceAll("<owner>", this.instance.getUtils().getMainUtils().getPlayerNameFromUUID(group.getOwner())).replaceAll("<memberslist>", membersList.toString()).replaceAll("<description>", group.getDescription());
            this.instance.getMessenger().sendMessageWithCustomPrefix(sender, line, "");
        }
    }
}

