/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.Message;
import pl.maciejnierzwicki.groupchat.data.DateRelationType;
import pl.maciejnierzwicki.groupchat.data.Group;
import pl.maciejnierzwicki.groupchat.data.MessagesRetrievalError;
import pl.maciejnierzwicki.groupchat.data.MessagesRetrievalResult;
import pl.maciejnierzwicki.groupchat.data.PlayerSettings;
import pl.maciejnierzwicki.groupchat.data.PlayerTempData;
import pl.maciejnierzwicki.groupchat.events.GroupModifyEvent;
import pl.maciejnierzwicki.groupchat.events.PlayerSettingsModifyEvent;
import pl.maciejnierzwicki.groupchat.events.PlayerSoundNotificationsNumberModifyEvent;
import pl.maciejnierzwicki.groupchat.inventories.SoundInventory;
import pl.maciejnierzwicki.groupchat.items.ItemMetaEditor;
import pl.maciejnierzwicki.groupchat.utils.DateUtils;
import pl.maciejnierzwicki.groupchat.utils.StringUtils;

public class MainUtils {
    private GroupChat instance;

    public MainUtils(GroupChat plugin) {
        this.instance = plugin;
    }

    public UUID getPlayerUUIDFromString(String uuidStr) {
        UUID uuid = this.instance.getUUIDIfAlreadyStored(uuidStr);
        if (uuid == null) {
            try {
                uuid = UUID.fromString(uuidStr);
                this.instance.addKnownPlayerUUIDIfNotStored(uuid, uuidStr);
            }
            catch (IllegalFormatException e) {
                return null;
            }
        }
        return uuid;
    }

    public String getPlayerNameFromUUID(UUID uuid) {
        String playerName = this.instance.getPlayerNameIfAlreadyStored(uuid);
        if (playerName == null) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                playerName = player.getName();
            } else {
                player = Bukkit.getOfflinePlayer((UUID)uuid);
                if (player != null) {
                    playerName = player.getName();
                }
            }
            if (playerName != null) {
                this.instance.addUUIDToPlayerNameMapping(uuid, playerName);
            }
        }
        return playerName;
    }

    public UUID getPlayerUUIDFromPlayerName(String playerName) {
        UUID playerUUID = this.instance.getPlayerUUIDIfAlreadyStored(playerName);
        if (playerUUID == null) {
            Player player = Bukkit.getPlayer((String)playerName);
            if (player != null) {
                playerUUID = player.getUniqueId();
            } else {
                for (OfflinePlayer storedPlayer : Bukkit.getOfflinePlayers()) {
                    if (!storedPlayer.getName().equalsIgnoreCase(playerName)) continue;
                    playerUUID = storedPlayer.getUniqueId();
                    break;
                }
            }
            if (playerUUID != null) {
                this.instance.addUUIDToPlayerNameMapping(playerUUID, playerName);
            }
        }
        return playerUUID;
    }

    public static UUID getPlayerId(String playerName) {
        if (Bukkit.getPlayer((String)playerName) != null) {
            return Bukkit.getPlayer((String)playerName).getUniqueId();
        }
        if (Bukkit.getOfflinePlayer((String)playerName) != null) {
            return Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
        }
        return null;
    }

    public void reloadPlugin() {
        if (this.instance.getManagers() == null) {
            return;
        }
        this.instance.getManagers().getConfigManagers().reloadConfigs();
        this.instance.getMessages().load(this.instance.getManagers().getConfigManagers().getLangConfigManager());
        this.instance.getSettings().load(this.instance.getManagers().getConfigManagers().getMainConfigManager());
        this.instance.getManagers().getSoundConfigurationsManager().load();
        this.instance.getManagers().getGroupsManager().loadGroupsChatList();
        this.instance.setupMessenger();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerTempData tempData = this.instance.getManagers().getPlayerTempDataManager().getData(player.getUniqueId());
            SoundInventory soundInv = tempData.getLastSoundInventory();
            if (soundInv == null) continue;
            this.instance.getScheduler().runSync(() -> soundInv.load());
        }
    }

    public void sendPlayerSettingsModifyEventOnNextTick(PlayerSettings playerSettings) {
        this.instance.getScheduler().runSync(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerSettingsModifyEvent(playerSettings)));
    }

    public void sendGroupModifyEventOnNextTick(Group group) {
        this.instance.getScheduler().runSync(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GroupModifyEvent(group)));
    }

    public void sendPlayerSoundNotificationsNumberModifyEventOnNextTick(PlayerSettings playerSettings, int oldSoundID, int newSoundID) {
        this.instance.getScheduler().runSync(() -> Bukkit.getPluginManager().callEvent((Event)new PlayerSoundNotificationsNumberModifyEvent(playerSettings, oldSoundID, newSoundID)));
    }

    public int getRandomInt(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public ItemStack getMessageItem(Message message) {
        return this.getMessageItem(message, null, false);
    }

    public ItemStack getMessageItem(Message message, Player player) {
        return this.getMessageItem(message, player, false);
    }

    public ItemStack getMessageItem(Message message, Player player, boolean showActionsTip) {
        ItemMetaEditor itemMetaEditor = this.instance.getItemMetaEditor();
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        Group group = this.instance.getManagers().getGroupsManager().getGroup(message.getGroupID());
        String groupName = group != null ? group.getName() : "";
        lore.add(this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_NAME.replaceAll("<sender>", this.getPlayerNameFromUUID(message.getSenderUUID())).replaceAll("<group_shortname>", groupName));
        String message_content = message.getMessageContent();
        if (message_content.length() > 30) {
            List<String> words = StringUtils.getWordsFromMessage(message_content);
            String line = "";
            for (int i = 1; i <= words.size(); ++i) {
                line = line + words.get(i - 1);
                if (i + 1 <= words.size()) {
                    if (line.length() + words.get(i).length() < 30) continue;
                    lore.add(this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", line));
                    line = "";
                    continue;
                }
                lore.add(this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", line));
                line = "";
            }
        } else {
            lore.add(this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MESSAGE_LINE.replaceAll("<text>", message_content));
        }
        if (showActionsTip && player != null && player.hasPermission("groupchat.history.actions")) {
            lore.addAll(this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_MORE);
        }
        meta = itemMetaEditor.setLore(meta, lore);
        meta = itemMetaEditor.setDisplayName(meta, this.instance.getMessages().INV_MESSAGES_HISTORY_MESSAGE_ENTRY_DATE.replaceAll("<date>", DateUtils.getFormattedDate(message.getDate(), this.instance.getSettings().MESSAGES_HISTORY_DATETIME_FORMATTER)));
        item.setItemMeta(meta);
        return item;
    }

    public LocalDateTime getLocalDateTimeFromCommandString(String dateTimeStr) {
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter formatter : this.instance.getSettings().IN_COMMAND_DATETIME_FORMATTERS) {
            try {
                localDateTime = LocalDateTime.parse(dateTimeStr, formatter);
                return localDateTime;
            }
            catch (DateTimeParseException e) {
            }
        }
        return localDateTime;
    }

    public MessagesRetrievalResult getMessagesMatchingExpression(String expression) {
        String startDateTimeStr;
        String[] namesPair;
        long timestamp = 0L;
        List<Message> messages = new ArrayList<Message>();
        String[] parts = expression.split(" ");
        boolean allMessagesOnServer = false;
        if (parts.length == 0) {
            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
        }
        if (parts.length == 1) {
            if (parts[0].equalsIgnoreCase("ALL")) {
                messages = this.instance.getStorage().getAllMessagesFromHistory();
                allMessagesOnServer = true;
            } else {
                String[] ids = parts[0].split(",");
                ArrayList<Long> idsList = new ArrayList<Long>();
                for (String id : ids) {
                    try {
                        Long msgId = Long.parseLong(id);
                        idsList.add(msgId);
                    }
                    catch (NumberFormatException ex) {
                        return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_MESSAGE_ID);
                    }
                }
                messages = this.instance.getStorage().getMessagesFromHistory(idsList);
            }
        } else if (parts.length == 2) {
            namesPair = parts[0].split(",");
            if (namesPair.length > 2) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_EXPRESSION);
            }
            boolean isNamesPair = namesPair.length == 2;
            String playerName = namesPair[0];
            UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(playerName);
            if (playerUUID == null) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_PLAYER);
            }
            String playerUUIDStr = playerUUID.toString();
            Group group = null;
            if (isNamesPair && (group = this.instance.getManagers().getGroupsManager().getGroup(namesPair[1])) == null) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_GROUP);
            }
            if (parts[1].equalsIgnoreCase("ALL")) {
                messages = !isNamesPair ? this.instance.getStorage().getGroupMessagesFromHistory(playerUUIDStr) : this.instance.getStorage().getGroupMessagesFromHistory(group.getID(), playerUUIDStr);
            } else {
                boolean isValidDateTimePresent = true;
                String dateTimeStr = parts[1];
                Instant instant = null;
                LocalDateTime localDateTime = this.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                instant = localDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                switch (parts[0].toUpperCase()) {
                    case "BEFORE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.BEFORE);
                        break;
                    }
                    case "AFTER": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.AFTER);
                        break;
                    }
                    case "TO": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.TO);
                        break;
                    }
                    case "SINCE": {
                        if (!isValidDateTimePresent) {
                            return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                        }
                        messages = this.instance.getStorage().getMessagesFromHistoryRelativeToDate(timestamp, DateRelationType.SINCE);
                    }
                }
            }
        } else if (parts.length == 3) {
            if (parts[0].equalsIgnoreCase("RANGE")) {
                startDateTimeStr = parts[1];
                String endDateTimeStr = parts[2];
                Instant endInstant = null;
                LocalDateTime startLocalDateTime = this.getLocalDateTimeFromCommandString(startDateTimeStr);
                LocalDateTime endLocalDateTime = this.getLocalDateTimeFromCommandString(endDateTimeStr);
                if (startLocalDateTime == null || endLocalDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant startInstant = startLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                endInstant = endLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                long startTimestamp = startInstant.toEpochMilli();
                long endTimestamp = endInstant.toEpochMilli();
                messages = this.instance.getStorage().getMessagesFromHistoryInDatesRange(startTimestamp, endTimestamp);
            } else {
                namesPair = parts[0].split(",");
                String dateTimeStr = parts[2];
                LocalDateTime localDateTime = this.getLocalDateTimeFromCommandString(dateTimeStr);
                if (localDateTime == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
                }
                Instant instant = localDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
                timestamp = instant.toEpochMilli();
                if (namesPair.length < 2) {
                    String playerName = parts[0];
                    UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(playerName);
                    String playerUUIDStr = playerUUID.toString();
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(playerUUIDStr, (Long)timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(playerUUIDStr, (Long)timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(playerUUIDStr, (Long)timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(playerUUIDStr, (Long)timestamp, DateRelationType.SINCE);
                        }
                    }
                } else {
                    String playerName = namesPair[0];
                    UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(playerName);
                    String playerUUIDStr = playerUUID.toString();
                    Group group = this.instance.getManagers().getGroupsManager().getGroup(namesPair[1]);
                    if (group == null) {
                        return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_GROUP);
                    }
                    switch (parts[1].toUpperCase()) {
                        case "BEFORE": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(group.getID(), playerUUIDStr, timestamp, DateRelationType.BEFORE);
                            break;
                        }
                        case "AFTER": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(group.getID(), playerUUIDStr, timestamp, DateRelationType.AFTER);
                            break;
                        }
                        case "TO": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(group.getID(), playerUUIDStr, timestamp, DateRelationType.TO);
                            break;
                        }
                        case "SINCE": {
                            messages = this.instance.getStorage().getGroupMessagesFromHistoryRelativeToDate(group.getID(), playerUUIDStr, timestamp, DateRelationType.SINCE);
                        }
                    }
                }
            }
        } else if (parts.length == 4 && parts[1].equalsIgnoreCase("RANGE")) {
            startDateTimeStr = parts[2];
            String endDateTimeStr = parts[3];
            Instant endInstant = null;
            LocalDateTime startLocalDateTime = this.getLocalDateTimeFromCommandString(startDateTimeStr);
            LocalDateTime endLocalDateTime = this.getLocalDateTimeFromCommandString(endDateTimeStr);
            if (startLocalDateTime == null || endLocalDateTime == null) {
                return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_DATETIME_FORMAT);
            }
            Instant startInstant = startLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
            endInstant = endLocalDateTime.atZone(ZoneId.of(this.instance.getSettings().TIME_ZONE)).toInstant();
            long startTimestamp = startInstant.toEpochMilli();
            long endTimestamp = endInstant.toEpochMilli();
            String[] namesPair2 = parts[0].split(",");
            if (namesPair2.length < 2) {
                String playerName = parts[0];
                UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(playerName);
                String playerUUIDStr = playerUUID.toString();
                messages = this.instance.getStorage().getGroupMessagesFromHistoryInDatesRange(playerUUIDStr, (Long)startTimestamp, (Long)endTimestamp);
            } else {
                String playerName = parts[0];
                UUID playerUUID = this.instance.getUtils().getMainUtils().getPlayerUUIDFromPlayerName(playerName);
                String playerUUIDStr = playerUUID.toString();
                Group group = this.instance.getManagers().getGroupsManager().getGroup(namesPair2[1]);
                if (group == null && group == null) {
                    return new MessagesRetrievalResult(messages).withError(MessagesRetrievalError.INVALID_GROUP);
                }
                messages = this.instance.getStorage().getGroupMessagesFromHistoryInDatesRange(group.getID(), playerUUIDStr, startTimestamp, endTimestamp);
            }
        }
        MessagesRetrievalResult result = new MessagesRetrievalResult(messages);
        if (allMessagesOnServer) {
            result.markContainsAllStoredMessages();
        }
        return result;
    }

    public List<String> getApplicablePlayerCompletions(CommandSender sender, String playerArg) {
        ArrayList<String> completions = new ArrayList<String>();
        boolean first_arg_not_empty = playerArg != null && !playerArg.isEmpty();
        boolean vanish_support = this.instance.getManagers().getIntegrationsManager().isVanishSupported();
        boolean sender_vanish_bypass = sender.hasPermission("groupchat.vanishbypass");
        boolean essentials_ignore_respect = this.instance.getSettings().ESSENTIALS_IGNORE_RESPECT;
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (vanish_support && this.instance.getVanish().isVanished(player) && !sender_vanish_bypass || essentials_ignore_respect && (this.instance.getManagers().getIntegrationsManager().isIgnoredOnEssentials(sender.getName(), player.getName()) || this.instance.getManagers().getIntegrationsManager().isIgnoredOnEssentials(player.getName(), sender.getName())) || sender instanceof Player && !((Player)sender).canSee(player) && !sender_vanish_bypass) continue;
            if (first_arg_not_empty) {
                if (!player.getName().toLowerCase().startsWith(playerArg.toLowerCase())) continue;
                completions.add(player.getName());
                continue;
            }
            completions.add(player.getName());
        }
        return completions;
    }

    public String getServerVersion() {
        String version;
        try {
            version = Bukkit.getBukkitVersion().split("-")[0];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return null;
        }
        return version;
    }

    public boolean isMinecraftVersionAtLeast(String versionStr) {
        return this.compareVersions(this.getServerVersion(), versionStr) >= 0;
    }

    public int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }

    public String getValidDefaultSoundsFileName() {
        switch (this.getServerVersion()) {
            case "1.7.2": 
            case "1.7.4": 
            case "1.7.5": 
            case "1.7.6": 
            case "1.7.7": 
            case "1.7.8": 
            case "1.7.9": 
            case "1.7.10": 
            case "1.8": 
            case "1.8.1": 
            case "1.8.2": 
            case "1.8.3": 
            case "1.8.4": 
            case "1.8.5": 
            case "1.8.6": 
            case "1.8.7": 
            case "1.8.8": 
            case "1.8.9": {
                return "sounds_1.7-1.8.yml";
            }
            case "1.9": 
            case "1.9.1": 
            case "1.9.2": 
            case "1.9.3": 
            case "1.9.4": 
            case "1.10": 
            case "1.10.1": 
            case "1.10.2": 
            case "1.11": 
            case "1.11.1": 
            case "1.11.2": {
                return "sounds_1.9-1.11.yml";
            }
            case "1.12": 
            case "1.12.1": 
            case "1.12.2": {
                return "sounds_1.12.yml";
            }
            case "1.13": 
            case "1.13.1": 
            case "1.13.2": {
                return "sounds_1.13.yml";
            }
            case "1.14": 
            case "1.14.1": 
            case "1.14.2": 
            case "1.14.3": 
            case "1.14.4": {
                return "sounds_1.14.yml";
            }
        }
        return "sounds.yml";
    }
}

