/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringUtils {
    public static String getStringFromMap(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        if (map == null) {
            return sb.append("").toString();
        }
        if (map.isEmpty()) {
            return sb.append("").toString();
        }
        Iterator<Map.Entry<String, List<String>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            String name = entry.getKey();
            List<String> ignored_names = entry.getValue();
            if (ignored_names == null || ignored_names.isEmpty()) continue;
            StringBuilder entry_str = new StringBuilder();
            entry_str.append(name + ":");
            Iterator<String> ignored_it = ignored_names.iterator();
            while (ignored_it.hasNext()) {
                entry_str.append(ignored_it.next());
                if (!ignored_it.hasNext()) continue;
                entry_str.append(",");
            }
            sb.append(entry_str.toString());
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static String getStringFromSet(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        if (set == null) {
            return sb.append("").toString();
        }
        if (set.isEmpty()) {
            return sb.append("").toString();
        }
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static String getStringFromList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        if (list == null) {
            return sb.append("").toString();
        }
        if (list.isEmpty()) {
            return sb.append("").toString();
        }
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static Set<String> getSetFromString(String string) {
        String[] elements;
        HashSet<String> set = new HashSet<String>();
        if (string == null) {
            return set;
        }
        if (string.isEmpty()) {
            return set;
        }
        for (String element : elements = string.split(";")) {
            set.add(element);
        }
        return set;
    }

    public static String getSafeString(String string) {
        return string.replace("%", "%%").replace("%%", "%").replace("\\", "\\\\").replace("$", "\\$");
    }

    public static List<String> getWordsFromMessage(String message) {
        ArrayList<String> words = new ArrayList<String>();
        String wordContent = "";
        for (int i = 1; i <= message.length(); ++i) {
            if (!Character.isWhitespace(message.charAt(i - 1))) {
                wordContent = wordContent + message.charAt(i - 1);
                if (i + 1 <= message.length()) continue;
                words.add(wordContent);
                wordContent = "";
                continue;
            }
            wordContent = wordContent + " ";
            words.add(wordContent);
            wordContent = "";
        }
        return words;
    }
}

