/*
 * Decompiled with CFR 0.152.
 */
package pl.maciejnierzwicki.groupchat.utils;

import pl.maciejnierzwicki.groupchat.GroupChat;
import pl.maciejnierzwicki.groupchat.utils.GroupUtils;
import pl.maciejnierzwicki.groupchat.utils.InventoryEventUtils;
import pl.maciejnierzwicki.groupchat.utils.MainUtils;
import pl.maciejnierzwicki.groupchat.utils.MaterialUtils;

public class Utils {
    private MaterialUtils materialUtils;
    private MainUtils mainUtils;
    private GroupUtils groupUtils;
    private InventoryEventUtils invEventUtils;
    private GroupChat instance;

    public Utils(GroupChat plugin) {
        this.instance = plugin;
        this.mainUtils = new MainUtils(this.instance);
        this.materialUtils = new MaterialUtils(this.instance);
        this.groupUtils = new GroupUtils(this.instance);
        this.invEventUtils = new InventoryEventUtils(this.instance);
    }

    public MainUtils getMainUtils() {
        return this.mainUtils;
    }

    public MaterialUtils getMaterialUtils() {
        return this.materialUtils;
    }

    public GroupUtils getGroupUtils() {
        return this.groupUtils;
    }

    public InventoryEventUtils getInventoryEventUtils() {
        return this.invEventUtils;
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String input) {
        try {
            Long.parseLong(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean getBooleanFromInt(Integer value) {
        return value == 1;
    }

    public static Integer getIntegerFromBoolean(boolean value) {
        return value ? 1 : 0;
    }
}

